% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialise.R
\name{Initialise}
\alias{Initialise}
\title{Initialise a Dirichlet process object}
\usage{
Initialise(
  dpObj,
  posterior = TRUE,
  m = 3,
  verbose = TRUE,
  numInitialClusters = 1
)
}
\arguments{
\item{dpObj}{A Dirichlet process object.}

\item{posterior}{TRUE/FALSE value for whether the cluster parameters should be from the posterior. If false then the values are from the prior.}

\item{m}{Number of auxiliary variables to use for a non-conjugate mixing distribution. Defaults to m=3. See \code{\link{ClusterComponentUpdate}} for more details on m.}

\item{verbose}{Logical flag indicating whether to output the acceptance ratio for non-conjugate mixtures.}

\item{numInitialClusters}{Number of clusters to initialise with.}
}
\value{
A Dirichlet process object that has initial cluster allocations.
}
\description{
Initialise a Dirichlet process object by assigning all the data points to a single cluster with a posterior or prior draw for parameters.
}
