% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{tsnarmimp}
\alias{tsnarmimp}
\title{Remove and Impute Missing Values in a Multivariate Time Series}
\usage{
tsnarmimp(
  X,
  max.missing = 0.8,
  na.rm.method = c("LE", "all"),
  na.impute = c("median.ma.spline", "median.ma", "median", "rnorm"),
  ma.terms = 3L
)
}
\arguments{
\item{X}{a \code{T x n} numeric data matrix (incl. ts or xts objects) or data frame of stationary time series.}

\item{max.missing}{numeric. Proportion of series missing for a case to be considered missing.}

\item{na.rm.method}{character. Method to apply concerning missing cases selected through \code{max.missing}: \code{"LE"} only removes cases at the beginning or end of the sample, whereas \code{"all"} always removes missing cases.}

\item{na.impute}{character. Method to impute missing values for the PCA estimates used to initialize the EM algorithm. Note that data are standardized (scaled and centered) beforehand. Available options are:
\tabular{llll}{
\code{"median"} \tab\tab simple series-wise median imputation. \cr\cr
\code{"rnorm"} \tab\tab imputation with random numbers drawn from a standard normal distribution. \cr\cr
\code{"median.ma"} \tab\tab values are initially imputed with the median, but then a moving average is applied to smooth the estimates. \cr\cr
\code{"median.ma.spline"} \tab\tab "internal" missing values (not at the beginning or end of the sample) are imputed using a cubic spline, whereas missing values at the beginning and end are imputed with the median of the series and smoothed with a moving average.\cr\cr
}}

\item{ma.terms}{the order of the (2-sided) moving average applied in \code{na.impute} methods \code{"median.ma"} and \code{"median.ma.spline"}.}
}
\value{
The imputed matrix \code{X_imp}, with attributes:
\item{\code{"missing"}}{a missingness matrix \code{W} matching the dimensions of \code{X_imp}. }
\item{\code{"rm.rows"}}{and a vector of indices of rows (cases) with too many missing values that were removed. }
}
\description{
This function imputes missing values in a stationary multivariate time series using various
methods, and removes cases with too many missing values.
}
\examples{
library(xts)
str(tsnarmimp(BM14_M))

}
