% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_url.R
\name{URLs}
\alias{URLs}
\alias{get_url}
\alias{get_url_by_name}
\alias{get_url_by_id}
\alias{get_url_by_doi}
\title{Get Dataverse file download URL}
\usage{
get_url(
  file,
  dataset = NULL,
  format = c("original", "bundle"),
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  original = TRUE,
  ...
)

get_url_by_name(
  filename,
  dataset,
  format = c("original", "bundle"),
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  original = TRUE,
  ...
)

get_url_by_id(
  fileid,
  dataset = NULL,
  format = c("original", "bundle"),
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  original = TRUE,
  ...
)

get_url_by_doi(
  filedoi,
  dataset = NULL,
  format = c("original", "bundle"),
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  original = TRUE,
  ...
)
}
\arguments{
\item{file}{An integer specifying a file identifier; or a vector of integers
specifying file identifiers; or, if used with the prefix \code{"doi:"}, a
character with the file-specific DOI; or, if used without the prefix, a
filename accompanied by a dataset DOI in the \code{dataset} argument, or an object of
class \dQuote{dataverse_file} as returned by \code{\link{dataset_files}}.
Can be a vector for multiple files.}

\item{dataset}{A character specifying a persistent identification ID for a dataset,
for example \code{"doi:10.70122/FK2/HXJVJU"}. Alternatively, an object of class
\dQuote{dataverse_dataset} obtained by \code{dataverse_contents()}.}

\item{format}{A character string specifying a file format for download.
by default, this is \dQuote{original} (the original file format). If \code{NULL},
no query is added, so ingested files are returned in their ingested TSV form.
For tabular datasets, the option \dQuote{bundle} downloads the bundle
of the original and archival versions, as well as the documentation.
See \url{https://guides.dataverse.org/en/latest/api/dataaccess.html} for details.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server.
Multiple Dataverse installations exist, with \code{"dataverse.harvard.edu"} being the
most major. The server can be defined each time within a function, or it can
be set as a default via an environment variable. To set a default, run
\code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.harvard.edu")}
or add \verb{DATAVERSE_SERVER = "dataverse.harvard.edu} in one's \code{.Renviron}
file (\code{usethis::edit_r_environ()}), with the appropriate domain as its value.}

\item{original}{A logical, defaulting to TRUE. If a ingested (.tab) version is
available, download the original version instead of the ingested? If there was
no ingested version, is set to NA. Note in \verb{get_dataframe_*},
\code{original} is set to FALSE by default. Either can be changed.}

\item{...}{Additional arguments passed to an HTTP request function, such as
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}.}

\item{filename}{Filename of the dataset, with file extension as shown in Dataverse
(for example, if nlsw88.dta was the original but is displayed as the ingested
nlsw88.tab, use the ingested version.)}

\item{fileid}{A numeric ID internally used for \code{get_file_by_id}. Can be a vector for multiple files.}

\item{filedoi}{A DOI for a single file (not the entire dataset), of the form
\code{"10.70122/FK2/PPIAXE/MHDB0O"} or \code{"doi:10.70122/FK2/PPIAXE/MHDB0O"}.
Can be a vector for multiple files.}
}
\value{
A string or a list of strings that are URLs.
}
\description{
Get URL of associated file. \verb{get_url_*} functions return a URL as
a string. This can be then used in other functions such as \code{curl::curl_download()}.
}
\details{
This function does not download the associated data.
In contrast, \code{get_dataframe()} downloads the requested file to a tempfile, and then uses R
to read it. And \code{get_file(.., return_url = FALSE)} reads the binary file into
R's memory with \code{httr::GET()}. \code{get_url()} simply return the URL for download.
}
\examples{
\dontrun{
# get URLs
get_url_by_name(
  filename = "nlsw88.tab",
  dataset  = "10.70122/FK2/PPIAXE",
  server   = "demo.dataverse.org"
)
# https://demo.dataverse.org/api/access/datafile/1734017?format=original

# For ingested, tab-delimited files
get_url_by_name(
  filename = "nlsw88.tab",
  dataset  = "10.70122/FK2/PPIAXE",
  original = FALSE,
  server   = "demo.dataverse.org"
)
# https://demo.dataverse.org/api/access/datafile/1734017

# To download to local directory
curl::curl_download(
 "https://demo.dataverse.org/api/access/datafile/1734017?format=original",
 destfile = "nlsw88.dta")
}
}
