% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctACF.R
\name{ctACF}
\alias{ctACF}
\title{Continuous Time Autocorrelation Function (ctACF)}
\usage{
ctACF(
  dat,
  varnames = "auto",
  idcol = "id",
  timecol = "time",
  plot = TRUE,
  timestep = "auto",
  time.max = "auto",
  nboot = 100,
  ...
)
}
\arguments{
\item{dat}{The input data in data frame or data table format.}

\item{varnames}{Character vector of variable names in the data to compute the ACF for. 'auto' uses all columns that are not time / id.}

\item{idcol}{The name of the column containing subject IDs (default is 'id').}

\item{timecol}{The name of the column containing time values (default is 'time').}

\item{plot}{A logical value indicating whether to create a plot (default is TRUE).}

\item{timestep}{The time step for discretizing data. 'auto' to automatically determine
the timestep based on data distribution (default is 'auto'). 
In this case the timestep is computed as 1/10th of the 10th percentile for time intervals in the data.}

\item{time.max}{The maximum time lag to compute the ACF (default is 10). If 'auto', is set to 10 times the 90th percentile interval in the data.}

\item{nboot}{The number of bootstrap samples for confidence interval estimation (default is 100).}

\item{...}{additional arguments (such as demean=FALSE) to pass to the \code{stats::acf} function.}
}
\value{
If 'plot' is TRUE, the function returns a ggplot object of the ACF plot. If 'plot' is
        FALSE, it returns a data table with ACF estimates and confidence intervals.
}
\description{
This function computes an approximate continuous time autocorrelation function (ACF) for data
containing multiple subjects and/or variables.
}
\details{
This function computes the continuous time ACF by discretizing the data and then
performing bootstrapped ACF calculations to estimate the confidence intervals. It can create
ACF plots with confidence intervals if 'plot' is set to TRUE.
}
\examples{
data.table::setDTthreads(1) #ignore this line
# Example usage:
head(ctstantestdat)
ctACF(ctstantestdat,varnames=c('Y1'),idcol='id',timecol='time',nboot=5)

}
\seealso{
\code{\link{ctDiscretiseData}}
}
