% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crwMLE.R
\name{crwMLE}
\alias{crwMLE}
\alias{crwMLE.default}
\alias{crwMLE.SpatialPoints}
\alias{crwMLE.sf}
\title{Fit Continuous-Time Correlated Random Walk Models to Animal Telemetry Data}
\usage{
crwMLE(data, ...)

\method{crwMLE}{default}(
  data,
  mov.model = ~1,
  err.model = NULL,
  activity = NULL,
  drift = FALSE,
  coord = c("x", "y"),
  proj = NULL,
  Time.name = "time",
  time.scale = NULL,
  theta = NULL,
  fixPar = NULL,
  method = "Nelder-Mead",
  control = NULL,
  constr = list(lower = -Inf, upper = Inf),
  prior = NULL,
  need.hess = TRUE,
  initialSANN = list(maxit = 200),
  attempts = 1,
  retrySD = 1,
  skip_check = FALSE,
  ...
)

\method{crwMLE}{SpatialPoints}(
  data,
  mov.model = ~1,
  err.model = NULL,
  activity = NULL,
  drift = FALSE,
  Time.name = "time",
  time.scale = NULL,
  theta = NULL,
  fixPar = NULL,
  method = "Nelder-Mead",
  control = NULL,
  constr = list(lower = -Inf, upper = Inf),
  prior = NULL,
  need.hess = TRUE,
  initialSANN = list(maxit = 200),
  attempts = 1,
  retrySD = 1,
  skip_check = FALSE,
  coord = NULL,
  ...
)

\method{crwMLE}{sf}(
  data,
  mov.model = ~1,
  err.model = NULL,
  activity = NULL,
  drift = FALSE,
  Time.name = "time",
  time.scale = NULL,
  theta = NULL,
  fixPar = NULL,
  method = "Nelder-Mead",
  control = NULL,
  constr = list(lower = -Inf, upper = Inf),
  prior = NULL,
  need.hess = TRUE,
  initialSANN = list(maxit = 200),
  attempts = 1,
  retrySD = 1,
  skip_check = FALSE,
  ...
)
}
\arguments{
\item{data}{a data set of location observations as a data.frame, tibble,
SpatialPointsDataFrame ('sp' package), or a data.frame of class 'sf' that
contains a geometry column of type \code{sfc_POINT}}

\item{...}{further arguments passed to or from other methods}

\item{mov.model}{formula object specifying the time indexed covariates for
movement parameters.}

\item{err.model}{A 2-element list of formula objects specifying the time
indexed covariates for location error parameters.}

\item{activity}{formula object giving the covariate for the activity (i.e., stopped or fully moving)
portion of the model.}

\item{drift}{logical indicating whether or not to include a random
drift component. For most data this is usually not necessary. See \code{\link{northernFurSeal}} for an example
using a drift model.}

\item{coord}{A 2-vector of character values giving the names of the "X" and
"Y" coordinates in \code{data}. Ignored if \code{data} inherits class
'sf' or 'sp'.}

\item{proj}{A valid epsg integer code or proj4string for \code{data} that does not
inherit either 'sf' or 'sp'. A valid 'crs' list is also accepted. Otherwise, ignored.}

\item{Time.name}{character indicating name of the location time column. It is
strongly preferred that this column be of type POSIXct and in UTC.}

\item{time.scale}{character. Scale for conversion of POSIX time to numeric 
for modeling. Defaults to "hours" and most users will not need to change this.}

\item{theta}{starting values for parameter optimization.}

\item{fixPar}{Values of parameters which are held fixed to the given value.}

\item{method}{Optimization method that is passed to \code{\link{optim}}.}

\item{control}{Control list which is passed to \code{\link{optim}}.}

\item{constr}{Named list with elements \code{lower} and \code{upper} that
are vectors the same length as theta giving the box constraints for the
parameters}

\item{prior}{A function returning the log-density function of the parameter
prior distribution. THIS MUST BE A FUNCTION OF ONLY THE FREE PARAMETERS. Any 
fixed parameters should not be included.}

\item{need.hess}{A logical value which decides whether or not to evaluate
the Hessian for parameter standard errors}

\item{initialSANN}{Control list for \code{\link{optim}} when simulated
annealing is used for obtaining start values. See details}

\item{attempts}{The number of times likelihood optimization will be
attempted in cases where the fit does not converge or is otherwise non-valid}

\item{retrySD}{optional user-provided standard deviation for adjusting
starting values when attempts > 1. Default value is 1.}

\item{skip_check}{Skip the likelihood optimization check and return the fitted values.
Can be useful for debugging problem fits.}
}
\value{
A list with the following elements:
\item{par}{Parameter maximum likelihood estimates (including fixed parameters)}
\item{estPar}{MLE without fixed parameters}
\item{se}{Standard error of MLE}
\item{ci}{95\% confidence intervals for parameters}
\item{Cmat}{Parameter covariance matrix}
\item{loglik}{Maximized log-likelihood value}
\item{aic}{Model AIC value}
\item{coord}{Coordinate names provided for fitting}
\item{fixPar}{Fixed parameter values provided}
\item{convergence}{Indicator of convergence (0 = converged)}
\item{message}{Messages given by \code{optim} during parameter optimization}
\item{activity}{Model provided for stopping variable}
\item{drift}{Logical value indicating random drift model}
\item{mov.model}{Model description for movement component}
\item{err.model}{Model description for location error component}
\item{n.par}{number of parameters}
\item{nms}{parameter names}
\item{n.mov}{number of movement parameters}
\item{n.errX}{number or location error parameters for ``longitude'' error model}
\item{n.errY}{number or location error parameters for ``latitude'' error model}
\item{stop.mf}{covariate for stop indication in stopping models}
\item{polar.coord}{Logical indicating coordinates are polar latitude and longitude}
\item{init}{Initial values for parameter optimization}
\item{data}{Original data.frame used to fit the model}
\item{lower}{The lower parameter bounds}
\item{upper}{The upper parameter bounds}
\item{need.hess}{Logical value}
\item{runTime}{Time used to fit model}
}
\description{
The function uses the Kalman filter to estimate movement parameters in a
state-space version of the continuous-time movement model. Separate models
are specified for movement portion and the location error portion. Each
model can depend on time indexed covariates. A \dQuote{haul out} model where
movement is allowed to completely stop, as well as, a random drift model can
be fit with this function.
}
\details{
\itemize{
\item A full model specification involves 4 components: a movement model, an
activity model, 2 location error models, and a drift indication. The
movement model (\code{mov.model}) specifies how the movement parameters
should vary over time. This is a function of specified, time-indexed,
covariates. The movement parameters (sigma for velocity variation and beta
for velocity autocorrelation) are both modeled with a log link as par =
exp(eta), where eta is the linear predictor based on the covariates. The
\code{err.model} specification is a list of 2 such models, one for
\dQuote{X (longitude)} and one for \dQuote{Y (latitude)} (in that order) location
error. If only one location error model is given, it is used for both
coordinates (parameter values as well). If \code{drift.model} is set to
\code{TRUE}, then, 2 additional parameters are estimated for the drift
process, a drift variance and a beta multiplier. 

\item \code{theta} and \code{fixPar} are vectors with the appropriate number or
parameters. \code{theta} contains only those parameters which are to be
estimated, while \code{fixPar} contains all parameter values with \code{NA}
for parameters which are to be estimated.

\item The data set specified by \code{data} must contain a numeric or POSIXct column which is
used as the time index for analysis. The column name is specified by the
\code{Time.name} argument and it is strongly suggested that this column be of
POSIXct type and in UTC. If a POSIXct column is used it is internally converted to a
numeric vector with units of \code{time.scale}. \code{time.scale} defaults to
NULL and an appropriate option will be chosen ("seconds","minutes","days","weeks")
based on the median time interval. The user can override this by specifying one
of those time intervals directly. If a numeric time vector is used, then 
the \code{time.scale} is ignored and there
is no adjustment to the data. Also, for activity models, the
activity covariate must be between 0 and 1 inclusive, with 0 representing complete stop
of the animal (no true movement, however, location error can still occur) and 1 
represent unhindered movement. The coordinate location should have \code{NA} where no
location is recorded, but there is a change in the movement covariates.

\item The CTCRW models can be difficult to provide good initial values for
optimization. If \code{initialSANN} is specified then simulated annealing is
used first to obtain starting values for the specified optimization method.
If simulated annealing is used first, then the returned \code{init} list of
the crwFit object will be a list with the results of the simulated annealing
optimization.

\item The \code{attempts} argument instructs \code{crwMLE} to attempt a fit
multiple times. Each time, the fit is inspected for convergence, whether
the covariance matrix could be calculated, negative values in the diag 
of the covariance matrix, or NA values in the standard errors. If, after
n attempts, the fit is still not valid a \code{simpleError} object is
returned. Users should consider increasing the number of attempts OR
adjusting the standard deviation value for each attempt by setting
\code{retrySD}. The default value for \code{retrySD} is 1, but users may
need to increase or decrease to find a valid fit. Adjusting other
model parameters may also be required.
}
}
\author{
Devin S. Johnson, Josh M. London
}
