% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidents.R
\name{incidents}
\alias{incidents}
\title{Identify incident events separated by a minimum time window}
\usage{
incidents(data, window_hours, time_var, join_key = NULL)
}
\arguments{
\item{data}{A time series data frame that includes the columns 'join_key'
and 'time_var'}

\item{window_hours}{A numeric value specifying the number of hours to
separate contiguous episodes and distinct episodes}

\item{time_var}{A string name of the time stamp column in the time series
data frame}

\item{join_key}{An optional string name of the column to group observations}
}
\value{
A data.frame, data.table with the time stamps of distinct, incident
 episodes separated by at least 'window_hours'
}
\description{
A function that reads in a time series data frame along with a specified
 time window and identifies incident events that are separated in time.
The user must specify the number of hours over which events are considered
 to be the same episode, the time stamp variable, and an optional variable
 to group episodes. This function was motivated by examples where there may
 be multiple observations of the same illness episode combined with
 observations of distinct illness episodes and there is a need to
 distinguish between episodes. This function assumes that the duration of
 an episode is non-zero. If every non-equal instant is a distinct episode,
 there is no need to use this function.
Two ways to distinguish between episodes with non-zero duration over time
 are: (1) bucket observations over a pre-fixed time frame that is applied to
 all observation; (2) bucket observations over a fixed window of time. An
 example of (1) is considering observations in the same month to be the same
 episode and observations in different months to be distinct episodes. The
 incident() function addresses (2) by specifying a time window and
 identifying the first observation of each episode. The use can also specify
 a 'join_key' variable (person, encounter, etc.) to group episodes.
 The 'window_hours' argument serves as the lower bound to separate
 observations that are considered the same episode versus distinct episodes.
}
\section{Imported functions}{

general data.table syntax
}

\section{Errors}{

This function returns errors for:
\itemize{
 \item missing arguments (join_key is missing by default)
 \item passing arguments with invalid classes (data must be a data frame
   and window_hours must be numeric)
 \item passing join_key or time_var values that are not column
   names in input data
 \item passing time_var column in data that is not POSIXct class
}
}

\examples{
library(data.table)
systolic_bp <- as.data.table(vitals[VARIABLE == "SYSTOLIC_BP"])
systolic_bp[, RECORDED_TIME := as.POSIXct(RECORDED_TIME,
  format = "\%Y-\%m-\%dT\%H:\%M:\%SZ", tz = "UTC")]

# Identify systolic blood pressure measurements for each patient that are
 # separated by at least 24 hours
incidents(systolic_bp, window_hours = 24, join_key = "PAT_ID",
 time_var = "RECORDED_TIME")

# Identify systolic blood pressure measurements that are separated by at
 # least 24 hours
incidents(systolic_bp, window_hours = 24, time_var = "RECORDED_TIME")

}
