% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.apply.calibration.R
\name{logistic.apply.calibration}
\alias{logistic.apply.calibration}
\title{Calculate the calibrated LRs with the model precomputed}
\usage{
logistic.apply.calibration(LR, model)
}
\arguments{
\item{LR}{a vector of likelihood ratios to be calibrated (raw values).}

\item{model}{a logistic.calibrate.set() fitted model to be applied. This variable can be the reture of the logistic.calibrate.set() or the logistic.calibrate.set()$fit variable.}
}
\value{
a \code{list} with the calibrated LR values
}
\description{
This function perform the logistic calibration on the provided data.
In the context of likelihood ratios, the 'ideal' value for the LR is Infinity for the same source dataset, and 0 for the different-sources dataset.
The 'post' values are fixed to 1 for the same source and 0 for the same different-sources datasets (corresponding to the posterior probability P(H_ss|E)).
}
\examples{
 # the list of LRs for the same source proposition
LR.same = c(0.5, 2, 4, 6, 8, 10)
# the list of LRs for the different source proposition
LR.different = c(0.2, 0.4, 0.6, 0.8, 1.1)
# compute the logistic calibration on the data
model = logistic.calibrate.get.model(LR.same, LR.different) 
 # the list of news LRs (to be calibrated)
LR.unknown = c(0.6, 0.7, 1.2, 5)
# compute the calibrated LRs for the list with the model
logistic.apply.calibration(LR.unknown, model)

}
\seealso{
\code{\link[=logistic.calibrate.set]{logistic.calibrate.set()}}
}
\author{
Marco De Donno
}
