% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model-method-sample_mpi}
\alias{model-method-sample_mpi}
\alias{sample_mpi}
\title{Run Stan's MCMC algorithms with MPI}
\usage{
sample_mpi(
  data = NULL,
  mpi_cmd = "mpiexec",
  mpi_args = NULL,
  seed = NULL,
  refresh = NULL,
  init = NULL,
  save_latent_dynamics = FALSE,
  output_dir = getOption("cmdstanr_output_dir"),
  output_basename = NULL,
  chains = 1,
  chain_ids = seq_len(chains),
  iter_warmup = NULL,
  iter_sampling = NULL,
  save_warmup = FALSE,
  thin = NULL,
  max_treedepth = NULL,
  adapt_engaged = TRUE,
  adapt_delta = NULL,
  step_size = NULL,
  metric = NULL,
  metric_file = NULL,
  inv_metric = NULL,
  init_buffer = NULL,
  term_buffer = NULL,
  window = NULL,
  fixed_param = FALSE,
  sig_figs = NULL,
  show_messages = TRUE,
  show_exceptions = TRUE,
  diagnostics = c("divergences", "treedepth", "ebfmi"),
  save_cmdstan_config = if (cmdstan_version() > "2.34.0") {
     TRUE
 } else {
    
    NULL
 },
  validate_csv = TRUE
)
}
\arguments{
\item{data}{(multiple options) The data to use for the variables specified in
the data block of the Stan program. One of the following:
\itemize{
\item A named list of \R objects with the names corresponding to variables
declared in the data block of the Stan program. Internally this list is
then written to JSON for CmdStan using \code{\link[=write_stan_json]{write_stan_json()}}. See
\code{\link[=write_stan_json]{write_stan_json()}} for details on the conversions performed on \R objects
before they are passed to Stan.
\item A path to a data file compatible with CmdStan (JSON or \R dump). See the
appendices in the CmdStan guide for details on using these formats.
\item \code{NULL} or an empty list if the Stan program has no data block.
}}

\item{mpi_cmd}{(string) The MPI launcher used for launching MPI
processes. The default launcher is \code{"mpiexec"}.}

\item{mpi_args}{(list) A list of arguments to use when launching MPI
processes. For example, \code{mpi_args = list("n" = 4)} launches the executable
as \verb{mpiexec -n 4 model_executable}, followed by CmdStan arguments for the
model executable.}

\item{seed}{(positive integer(s)) A seed for the (P)RNG to pass to CmdStan.
In the case of multi-chain sampling the single \code{seed} will automatically be
augmented by the the run (chain) ID so that each chain uses a different
seed. The exception is the transformed data block, which defaults to using
same seed for all chains so that the same data is generated for all chains
if RNG functions are used. The only time \code{seed} should be specified as a
vector (one element per chain) is if RNG functions are used in transformed
data and the goal is to generate \emph{different} data for each chain.}

\item{refresh}{(non-negative integer) The number of iterations between
printed screen updates. If \code{refresh = 0}, only error messages will be
printed.}

\item{init}{(multiple options) The initialization method to use for the
variables declared in the parameters block of the Stan program. One of the
following:
\itemize{
\item A real number \code{x>0}. This initializes \emph{all} parameters randomly between
\verb{[-x,x]} on the \emph{unconstrained} parameter space.;
\item The number \code{0}. This initializes \emph{all} parameters to \code{0};
\item A character vector of paths (one per chain) to JSON or Rdump files
containing initial values for all or some parameters. See
\code{\link[=write_stan_json]{write_stan_json()}} to write \R objects to JSON files compatible with
CmdStan.
\item A list of lists containing initial values for all or some parameters. For
MCMC the list should contain a sublist for each chain. For other model
fitting methods there should be just one sublist. The sublists should have
named elements corresponding to the parameters for which you are specifying
initial values. See \strong{Examples}.
\item A function that returns a single list with names corresponding to the
parameters for which you are specifying initial values. The function can
take no arguments or a single argument \code{chain_id}. For MCMC, if the
function has argument \code{chain_id} it will be supplied with the chain id
(from 1 to number of chains) when called to generate the initial values.
See
\strong{Examples}.
\item A \code{\link{CmdStanMCMC}}, \code{\link{CmdStanMLE}}, \code{\link{CmdStanVB}}, \code{\link{CmdStanPathfinder}},
or \code{\link{CmdStanLaplace}} fit object.
If the fit object's parameters are only a subset of the model
parameters then the other parameters will be drawn by Stan's default
initialization. The fit object must have at least some parameters that are the
same name and dimensions as the current Stan model. For the \code{sample} and
\code{pathfinder} method, if the fit object has fewer draws than the requested
number of chains/paths then the inits will be drawn using sampling with
replacement. Otherwise sampling without replacement will be used.
When a \code{\link{CmdStanPathfinder}} fit object is used as the init, if
. \code{psis_resample} was set to \code{FALSE} and \code{calculate_lp} was
set to \code{TRUE} (default), then resampling without replacement with Pareto
smoothed weights will be used. If \code{psis_resample} was set to \code{TRUE} or
\code{calculate_lp} was set to \code{FALSE} then sampling without replacement with
uniform weights will be used to select the draws.
PSIS resampling is used to select the draws for  \code{\link{CmdStanVB}},
and \code{\link{CmdStanLaplace}} fit objects.
\item A type inheriting from \code{posterior::draws}. If the draws object has less
samples than the number of requested chains/paths then the inits will be
drawn using sampling with replacement. Otherwise sampling without
replacement will be used. If the draws object's parameters are only a subset
of the model parameters then the other parameters will be drawn by Stan's
default initialization. The fit object must have at least some parameters
that are the same name and dimensions as the current Stan model.
}}

\item{save_latent_dynamics}{(logical) Should auxiliary diagnostic information
about the latent dynamics be written to temporary diagnostic CSV files?
This argument replaces CmdStan's \code{diagnostic_file} argument and the content
written to CSV is controlled by the user's CmdStan installation and not
CmdStanR (for some algorithms no content may be written). The default is
\code{FALSE}, which is appropriate for almost every use case. To save the
temporary files created when \code{save_latent_dynamics=TRUE} see the
\code{\link[=fit-method-save_latent_dynamics_files]{$save_latent_dynamics_files()}}
method.}

\item{output_dir}{(string) A path to a directory where CmdStan should write
its output CSV files. For MCMC there will be one file per chain; for other
methods there will be a single file. For interactive use this can typically
be left at \code{NULL} (temporary directory) since CmdStanR makes the CmdStan
output (posterior draws and diagnostics) available in \R via methods of the
fitted model objects. This can be set for an entire \R session using
\code{options(cmdstanr_output_dir)}. The behavior of \code{output_dir} is as follows:
\itemize{
\item If \code{NULL} (the default), then the CSV files are written to a temporary
directory and only saved permanently if the user calls one of the \verb{$save_*}
methods of the fitted model object (e.g.,
\code{\link[=fit-method-save_output_files]{$save_output_files()}}). These temporary
files are removed when the fitted model object is \link[base:gc]{garbage collected} (manually or automatically).
\item If a path, then the files are created in \code{output_dir} with names
corresponding to the defaults used by \verb{$save_output_files()}.
}}

\item{output_basename}{(string) A string to use as a prefix for the names of
the output CSV files of CmdStan. If \code{NULL} (the default), the basename of
the output CSV files will be comprised from the model name, timestamp, and
5 random characters.}

\item{chains}{(positive integer) The number of Markov chains to run. The
default is 4.}

\item{chain_ids}{(integer vector) A vector of chain IDs. Must contain as many
unique positive integers as the number of chains. If not set, the default
chain IDs are used (integers starting from \code{1}).}

\item{iter_warmup}{(positive integer) The number of warmup iterations to run
per chain. Note: in the CmdStan User's Guide this is referred to as
\code{num_warmup}.}

\item{iter_sampling}{(positive integer) The number of post-warmup iterations
to run per chain. Note: in the CmdStan User's Guide this is referred to as
\code{num_samples}.}

\item{save_warmup}{(logical) Should warmup iterations be saved? The default
is \code{FALSE}.}

\item{thin}{(positive integer) The period between saved samples. This should
typically be left at its default (no thinning) unless memory is a problem.}

\item{max_treedepth}{(positive integer) The maximum allowed tree depth for
the NUTS engine. See the \emph{Tree Depth} section of the CmdStan User's Guide
for more details.}

\item{adapt_engaged}{(logical) Do warmup adaptation? The default is \code{TRUE}.
If a precomputed inverse metric is specified via the \code{inv_metric} argument
(or \code{metric_file}) then, if \code{adapt_engaged=TRUE}, Stan will use the
provided inverse metric just as an initial guess during adaptation. To turn
off adaptation when using a precomputed inverse metric set
\code{adapt_engaged=FALSE}.}

\item{adapt_delta}{(real in \verb{(0,1)}) The adaptation target acceptance
statistic.}

\item{step_size}{(positive real) The \emph{initial} step size for the discrete
approximation to continuous Hamiltonian dynamics. This is further tuned
during warmup.}

\item{metric}{(string) One of \code{"diag_e"}, \code{"dense_e"}, or \code{"unit_e"},
specifying the geometry of the base manifold. See the \emph{Euclidean Metric}
section of the CmdStan User's Guide for more details. To specify a
precomputed (inverse) metric, see the \code{inv_metric} argument below.}

\item{metric_file}{(character vector) The paths to JSON or Rdump files (one
per chain) compatible with CmdStan that contain precomputed inverse
metrics. The \code{metric_file} argument is inherited from CmdStan but is
confusing in that the entry in JSON or Rdump file(s) must be named
\code{inv_metric}, referring to the \emph{inverse} metric. We recommend instead using
CmdStanR's \code{inv_metric} argument (see below) to specify an inverse metric
directly using a vector or matrix from your \R session.}

\item{inv_metric}{(vector, matrix) A vector (if \code{metric='diag_e'}) or a
matrix (if \code{metric='dense_e'}) for initializing the inverse metric. This
can be used as an alternative to the \code{metric_file} argument. A vector is
interpreted as a diagonal metric. The inverse metric is usually set to an
estimate of the posterior covariance. See the \code{adapt_engaged} argument
above for details about (and control over) how specifying a precomputed
inverse metric interacts with adaptation.}

\item{init_buffer}{(nonnegative integer) Width of initial fast timestep
adaptation interval during warmup.}

\item{term_buffer}{(nonnegative integer) Width of final fast timestep
adaptation interval during warmup.}

\item{window}{(nonnegative integer) Initial width of slow timestep/metric
adaptation interval.}

\item{fixed_param}{(logical) When \code{TRUE}, call CmdStan with argument
\code{"algorithm=fixed_param"}. The default is \code{FALSE}. The fixed parameter
sampler generates a new sample without changing the current state of the
Markov chain; only generated quantities may change. This can be useful
when, for example, trying to generate pseudo-data using the generated
quantities block. If the parameters block is empty then using
\code{fixed_param=TRUE} is mandatory. When \code{fixed_param=TRUE} the \code{chains} and
\code{parallel_chains} arguments will be set to \code{1}.}

\item{sig_figs}{(positive integer) The number of significant figures used
when storing the output values. By default, CmdStan represent the output
values with 6 significant figures. The upper limit for \code{sig_figs} is 18.
Increasing this value will result in larger output CSV files and thus an
increased usage of disk space.}

\item{show_messages}{(logical) When \code{TRUE} (the default), prints all output
during the execution process, such as iteration numbers and elapsed times.
If the output is silenced then the \code{\link[=fit-method-output]{$output()}} method
of the resulting fit object can be used to display the silenced messages.}

\item{show_exceptions}{(logical) When \code{TRUE} (the default), prints all
informational messages, for example rejection of the current proposal.
Disable if you wish to silence these messages, but this is not usually
recommended unless you are very confident that the model is correct up to
numerical error. If the messages are silenced then the
\code{\link[=fit-method-output]{$output()}} method of the resulting fit object can be
used to display the silenced messages.}

\item{diagnostics}{(character vector) The diagnostics to automatically check
and warn about after sampling. Setting this to an empty string \code{""} or
\code{NULL} can be used to prevent CmdStanR from automatically reading in the
sampler diagnostics from CSV if you wish to manually read in the results
and validate them yourself, for example using \code{\link[=read_cmdstan_csv]{read_cmdstan_csv()}}. The
currently available diagnostics are \code{"divergences"}, \code{"treedepth"}, and
\code{"ebfmi"} (the default is to check all of them).

These diagnostics are also available after fitting. The
\code{\link[=fit-method-sampler_diagnostics]{$sampler_diagnostics()}} method provides
access the diagnostic values for each iteration and the
\code{\link[=fit-method-diagnostic_summary]{$diagnostic_summary()}} method provides
summaries of the diagnostics and can regenerate the warning messages.

Diagnostics like R-hat and effective sample size are \emph{not} currently
available via the \code{diagnostics} argument but can be checked after fitting
using the \code{\link[=fit-method-summary]{$summary()}} method.}

\item{save_cmdstan_config}{(logical) When \code{TRUE} (the default), call CmdStan
with argument \code{"output save_config=1"} to save a json file which contains
the argument tree and extra information (equivalent to the output CSV file
header). This option is only available in CmdStan 2.34.0 and later.}

\item{validate_csv}{Deprecated. Use \code{diagnostics} instead.}
}
\value{
A \code{\link{CmdStanMCMC}} object.
}
\description{
The \verb{$sample_mpi()} method of a \code{\link{CmdStanModel}} object is
identical to the \verb{$sample()} method but with support for
MPI (message passing interface). The target audience for MPI are
those with large computer clusters. For other users, the
\code{\link[=model-method-sample]{$sample()}} method provides both parallelization of
chains and threading support for within-chain parallelization.

In order to use MPI with Stan, an MPI implementation must be
installed. For Unix systems the most commonly used implementations are
MPICH and OpenMPI. The implementations provide an MPI C++ compiler wrapper
(for example mpicxx), which is required to compile the model.

An example of compiling with MPI:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mpi_options = list(STAN_MPI=TRUE, CXX="mpicxx", TBB_CXX_TYPE="gcc")
mod = cmdstan_model("model.stan", cpp_options = mpi_options)
}\if{html}{\out{</div>}}

The C++ options that must be supplied to the
\link[=model-method-compile]{compile} call are:
\itemize{
\item \code{STAN_MPI}: Enables the use of MPI with Stan if \code{TRUE}.
\item \code{CXX}: The name of the MPI C++ compiler wrapper. Typically \code{"mpicxx"}.
\item \code{TBB_CXX_TYPE}: The C++ compiler the MPI wrapper wraps. Typically \code{"gcc"}
on Linux and \code{"clang"} on macOS.
}

In the call to the \verb{$sample_mpi()} method it is also possible to provide
the name of the MPI launcher (\code{mpi_cmd}, defaulting to \code{"mpiexec"}) and any
other MPI launch arguments (\code{mpi_args}). In most cases, it is enough to
only define the number of processes. To use \code{n_procs} processes specify
\code{mpi_args = list("n" = n_procs)}.
}
\examples{
\dontrun{
# mpi_options <- list(STAN_MPI=TRUE, CXX="mpicxx", TBB_CXX_TYPE="gcc")
# mod <- cmdstan_model("model.stan", cpp_options = mpi_options)
# fit <- mod$sample_mpi(..., mpi_args = list("n" = 4))
}

}
\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

The Stan Math Library's documentation
(\href{https://mc-stan.org/math/}{mc-stan.org/math}) for more
details on MPI support in Stan.

Other CmdStanModel methods: 
\code{\link{model-method-check_syntax}},
\code{\link{model-method-compile}},
\code{\link{model-method-diagnose}},
\code{\link{model-method-expose_functions}},
\code{\link{model-method-format}},
\code{\link{model-method-generate-quantities}},
\code{\link{model-method-laplace}},
\code{\link{model-method-optimize}},
\code{\link{model-method-pathfinder}},
\code{\link{model-method-sample}},
\code{\link{model-method-variables}},
\code{\link{model-method-variational}}
}
\concept{CmdStanModel methods}
