% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{model-method-expose_functions}
\alias{model-method-expose_functions}
\alias{expose_functions}
\alias{fit-method-expose_functions}
\title{Expose Stan functions to R}
\usage{
expose_functions(global = FALSE, verbose = FALSE)
}
\arguments{
\item{global}{(logical) Should the functions be added to the Global
Environment? The default is \code{FALSE}, in which case the functions are
available via the \code{functions} field of the R6 object.}

\item{verbose}{(logical) Should detailed information about generated code be
printed to the console? Defaults to \code{FALSE}.}
}
\description{
The \verb{$expose_functions()} method of a \code{\link{CmdStanModel}} object
will compile the functions in the Stan program's \code{functions} block and
expose them for use in \R. This can also be specified via the
\code{compile_standalone} argument to the \code{\link[=model-method-compile]{$compile()}}
method.

This method is also available for fitted model objects (\code{\link{CmdStanMCMC}}, \code{\link{CmdStanVB}}, etc.).
See \strong{Examples}.

Note: there may be many compiler warnings emitted during compilation but
these can be ignored so long as they are warnings and not errors.
}
\examples{
\dontrun{
stan_file <- write_stan_file(
 "
 functions {
   real a_plus_b(real a, real b) {
     return a + b;
   }
 }
 parameters {
   real x;
 }
 model {
   x ~ std_normal();
 }
 "
)
mod <- cmdstan_model(stan_file)
mod$expose_functions()
mod$functions$a_plus_b(1, 2)

fit <- mod$sample(refresh = 0)
fit$expose_functions() # already compiled because of above but this would compile them otherwise
fit$functions$a_plus_b(1, 2)
}


}
\seealso{
The CmdStanR website
(\href{https://mc-stan.org/cmdstanr/}{mc-stan.org/cmdstanr}) for online
documentation and tutorials.

The Stan and CmdStan documentation:
\itemize{
\item Stan documentation: \href{https://mc-stan.org/users/documentation/}{mc-stan.org/users/documentation}
\item CmdStan User’s Guide: \href{https://mc-stan.org/docs/cmdstan-guide/}{mc-stan.org/docs/cmdstan-guide}
}

Other CmdStanModel methods: 
\code{\link{model-method-check_syntax}},
\code{\link{model-method-compile}},
\code{\link{model-method-diagnose}},
\code{\link{model-method-format}},
\code{\link{model-method-generate-quantities}},
\code{\link{model-method-optimize}},
\code{\link{model-method-sample_mpi}},
\code{\link{model-method-sample}},
\code{\link{model-method-variables}},
\code{\link{model-method-variational}}
}
\concept{CmdStanModel methods}
