% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{cmdstanr_example}
\alias{cmdstanr_example}
\alias{print_example_program}
\title{Fit models for use in examples}
\usage{
cmdstanr_example(
  example = c("logistic", "schools", "schools_ncp"),
  method = c("sample", "optimize", "variational", "diagnose"),
  ...,
  quiet = TRUE
)

print_example_program(example = c("logistic", "schools", "schools_ncp"))
}
\arguments{
\item{example}{(string) The name of the example. The currently available
examples are
\itemize{
\item \code{"logistic"}: logistic regression with intercept and 3 predictors.
\item \code{"schools"}: the so-called "eight schools" model, a hierarchical
meta-analysis. Fitting this model will result in warnings about
divergences.
\item \code{"schools_ncp"}: non-centered parameterization of the "eight schools"
model that fixes the problem with divergences.
}

To print the Stan code for a given \code{example} use
\code{print_example_program(example)}.}

\item{method}{(string) Which fitting method should be used? The default is
the \code{"sample"} method (MCMC).}

\item{...}{Arguments passed to the chosen \code{method}. See the help pages for
the individual methods for details.}

\item{quiet}{(logical) If \code{TRUE} (the default) then fitting the model is
wrapped in \code{\link[utils:capture.output]{utils::capture.output()}}.}
}
\value{
The fitted model object returned by the selected \code{method}.
}
\description{
Fit models for use in examples
}
\examples{
\dontrun{
print_example_program("logistic")
fit_logistic_mcmc <- cmdstanr_example("logistic", chains = 2)
fit_logistic_mcmc$summary()

fit_logistic_optim <- cmdstanr_example("logistic", method = "optimize")
fit_logistic_optim$summary()

fit_logistic_vb <- cmdstanr_example("logistic", method = "variational")
fit_logistic_vb$summary()

print_example_program("schools")
fit_schools_mcmc <- cmdstanr_example("schools")
fit_schools_mcmc$summary()

print_example_program("schools_ncp")
fit_schools_ncp_mcmc <- cmdstanr_example("schools_ncp")
fit_schools_ncp_mcmc$summary()

# optimization fails for hierarchical model
cmdstanr_example("schools", "optimize", quiet = FALSE)
}

}
