# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_pcbbinom <- function(q, size, alpha, beta, lower_tail, log_p, tol, max_iter) {
    .Call(`_cbbinom_cpp_pcbbinom`, q, size, alpha, beta, lower_tail, log_p, tol, max_iter)
}

cpp_qcbbinom <- function(p, size, alpha, beta, lower_tail, log_p, p_tol, p_max_iter, root_tol, root_max_iter) {
    .Call(`_cbbinom_cpp_qcbbinom`, p, size, alpha, beta, lower_tail, log_p, p_tol, p_max_iter, root_tol, root_max_iter)
}

dcbblp <- function(x, m, a, b, tol, max_iter) {
    .Call(`_cbbinom_dcbblp`, x, m, a, b, tol, max_iter)
}

cpp_rcbbinom <- function(n, size, alpha, beta, p_tol, p_max_iter, root_tol, root_max_iter) {
    .Call(`_cbbinom_cpp_rcbbinom`, n, size, alpha, beta, p_tol, p_max_iter, root_tol, root_max_iter)
}

#' Generalized hypergeometric function
#'
#' \code{gen_hypergeo} computes generalized hypergeometric function.
#'
#' @param U,L Numeric vectors for upper and lower values.
#' @param x Numeric (1L) as common ratio.
#' @param tol Numeric (1L) as convergence tolerance.
#' @param max_iter Integer (1L) as iteration limit.
#' @param check_mode Logical (1L) indicating whether the mode of \code{x}
#' should be checked for obvious convergence failures.
#' @param log Logical (1L) indicating whether result is given as log(result).
#'
#' @return Result of computation. Warnings are issued if failing to converge.
#'
#' @note Change log:
#' \itemize{
#'   \item{0.1.0 Xiurui Zhu - Initiate the function.}
#' }
#' @author Xiurui Zhu
#'
#' @export
#'
#' @examples
#' gen_hypergeo(U = c(1.1, 0.2, 0.3), L = c(10.1, 4 * pi), x = 1,
#'               max_iter = 10000L, tol = 1e-6, check_mode = TRUE, log = FALSE)
gen_hypergeo <- function(U, L, x, tol, max_iter, check_mode, log) {
    .Call(`_cbbinom_gen_hypergeo`, U, L, x, tol, max_iter, check_mode, log)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call(`_cbbinom_RcppExport_registerCCallable`)
})
