#' @title Breakfast: Methods for Fast Multiple Change-point Detection and Estimation
#' @description A developing software suite for multiple change-point detection/estimation (data segmentation) in data sequences. 
#' @details
#' The current version implements methods for detecting changes in the data sequence modelled as (i) a piecewise-constant function plus i.i.d. Gaussian noise, 
#' (ii) a piecewise-constant function plus autoregressive time series,  
#' (iii) a piecewise-linear and continuous function plus i.i.d. Gaussian noise, and
#' (iv) a piecewise-linear and discontinuous function plus i.i.d. Gaussian noise.
#' This is carried out via a two-stage procedure combining solution path generation and model selection methodologies.
#' Change-point detection in breakfast is carried out in two stages, first the computation of a solution path, followed by a model selection step along the path. 
#' A variety of solution path and model selection methods are included, which can be accessed individually,
#' or through \link[breakfast]{breakfast}.
#' Currently supported solution path methods are: \link[breakfast]{sol.idetect}, \link[breakfast]{sol.idetect_seq},
#' \link[breakfast]{sol.wbs}, \link[breakfast]{sol.wbs2}, \link[breakfast]{sol.not}, \link[breakfast]{sol.tguh} and \link[breakfast]{sol.wcm}.
#' 
#' Currently supported model selection methods are: \link[breakfast]{model.ic}, \link[breakfast]{model.lp},
#' \link[breakfast]{model.sdll}, \link[breakfast]{model.thresh} and \link[breakfast]{model.gsa}.
#' 
#' Check back future versions for more change-point models and the corresponding methods.
#' @useDynLib breakfast, .registration = TRUE 
#' @author \itemize{
#' \item \href{https://www.andreasanastasiou-statistics.com/}{Andreas Anastasiou}
#' \item \href{http://personal.lse.ac.uk/cheny100/}{Yining Chen}
#' \item \href{https://sites.google.com/view/haeran-cho/}{Haeran Cho}
#' \item \href{http://stats.lse.ac.uk/fryzlewicz/}{Piotr Fryzlewicz}
#' }
#' 
#' We would like to thank Shakeel Gavioli-Akilagun, Anica Kostic, Shuhan Yang and Christine Yuen for their comments and suggestions that helped improve this package.
#' 
#' @seealso \code{browseVignettes(package = "breakfast")} contains a detailed comparative simulation study of various methods 
#' implemented in \link[breakfast]{breakfast} for the models (i), (iii) and (iv).
#'
#' @docType package
#' @name breakfast-package
NULL