% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assert}
\alias{assert}
\alias{assert_nona}
\alias{assert_args}
\alias{assert_lengths}
\alias{assert_int}
\alias{assert_one_int}
\alias{assert_one_bool}
\alias{assert_pos}
\alias{assert_01}
\alias{assert_multiple}
\alias{assert_class}
\alias{assert_class_or_null}
\alias{assert_all}
\alias{assert_dir}
\alias{assert_exist}
\alias{assert_noexist}
\alias{assert_nodots}
\alias{assert_ext}
\alias{assert_type}
\alias{assert_sorted}
\alias{assert_package}
\alias{assert_df_with_names}
\title{Assertions}
\usage{
assert_nona(x)

assert_args(f, args.name)

assert_lengths(...)

assert_int(x)

assert_one_int(x)

assert_one_bool(x)

assert_pos(x, strict = TRUE)

assert_01(x)

assert_multiple(x)

assert_class(x, class)

assert_class_or_null(x, class)

assert_all(x, value = TRUE)

assert_dir(dir.path)

assert_exist(file)

assert_noexist(file)

assert_nodots()

assert_ext(file, ext)

assert_type(x, type)

assert_sorted(x, strict = FALSE)

assert_package(pkg)

assert_df_with_names(df, names)
}
\arguments{
\item{x}{Usually a vector.}

\item{f}{A function.}

\item{args.name}{Vector of (argument) names to check.}

\item{...}{Objects to check.}

\item{strict}{Whether to check for strict positivity? Default is \code{TRUE}.}

\item{class}{Class to check.}

\item{value}{Value to check.}

\item{dir.path}{Directory to check.}

\item{file}{File to check.}

\item{ext}{Extension to check (without the dot at the beginning).}

\item{type}{Type to check.}

\item{pkg}{Name of a package.}

\item{df}{A data frame.}

\item{names}{Variable names to check.}
}
\description{
\itemize{
\item \code{assert_nona()}: checks that there is no missing value.
\item \code{assert_args()}: checks that \code{f} is a function and that it has arguments
called \code{args.name}.
\item \code{assert_lengths()}: checks that objects have the same length.
\item \code{assert_one_bool()}: checks whether either \code{TRUE} or \code{FALSE}.
\item \code{assert_one_int()}: checks that object is integer-ish of length 1.
\item \code{assert_int()}: checks that values are integer-ish (or \code{NULL}).
\item \code{assert_pos()}: checks that values are (strictly) positive.
\item \code{assert_01()}: checks that values are either \code{0} or \code{1}.
\item \code{assert_multiple()}: checks that there are multiple unique values.
Errors if there are one unique values (or none).
Warns if there are two unique values only.
\item \code{assert_class()}: checks that object is of a particular class.
\item \code{assert_class_or_null()}: checks that object is of a particular class
(or \code{NULL}).
\item \code{assert_all()}: checks that all values of an object are the same as \code{value}.
Default checks that values are all \code{TRUE}. This function tests equality;
beware precision errors (e.g. \code{(0.1 + 0.2) != 0.3}).
\item \code{assert_dir()}: checks that directory exists, or tries to create it.
\item \code{assert_exist()}: checks that file exists.
\item \code{assert_noexist()}: checks that file does not exist.
\item \code{assert_nodots()}: checks that \code{...} are not used in a function.
\item \code{assert_ext()}: checks that file has a particular extension.
\item \code{assert_type()}: checks that values are of a particular type.
\item \code{assert_sorted()}: checks that values are sorted.
\item \code{assert_package()}: checks that a package is installed.
\item \code{assert_df_with_names()}: checks that it is a data frame with some required
variables names. There can be additional variables as well.
}
}
\examples{
assert_nona(1:3)
assert_args(assert_nona, "x")
assert_lengths(1:3, 4:6, as.list(1:3))
assert_int(c(1, 2, 3))
assert_01(c(0, 1, 0))
assert_multiple(1:3)
assert_class(assert_nona, "function")
assert_all(1:3 > 0)
assert_all(rep(0, 3), 0)
assert_dir(tempdir())
assert_noexist(tmp <- tempfile())
write("test", tmp)
assert_exist(tmp)
assert_ext("test.txt", "txt")
assert_type(1:3, "integer")
assert_sorted(1:3)
assert_package("stats")
assert_df_with_names(iris, c("Sepal.Length", "Sepal.Width"))

test <- function(...) {
  assert_nodots()
  NULL
}
test()

}
