% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{summary.bayesianVARs_draws}
\alias{summary.bayesianVARs_draws}
\title{Summary statistics for bayesianVARs posterior draws.}
\usage{
\method{summary}{bayesianVARs_draws}(object, quantiles = c(0.25, 0.5, 0.75), ...)
}
\arguments{
\item{object}{An object of class \code{bayesianVARs_draws} usually obtained through
extractors like \code{\link[=coef.bayesianVARs_bvar]{coef.bayesianVARs_bvar()}} and
\code{\link[=vcov.bayesianVARs_bvar]{vcov.bayesianVARs_bvar()}}.}

\item{quantiles}{A vector of quantiles to evaluate.}

\item{...}{Currently ignored.}
}
\value{
A list object of class \code{bayesianVARs_draws_summary} holding
\itemize{
\item \code{mean}: Vector or matrix containing the posterior mean.
\item \code{sd}: Vector or matrix containing the posterior standard deviation .
\item \code{quantiles}: Array containing the posterior quantiles.
}
}
\description{
Summary statistics for bayesianVARs posterior draws.
}
\examples{

# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]
# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Extract posterior draws of VAR coefficients
bvar_coefs <- coef(mod)

# Compute summary statistics
summary_stats <- summary(bvar_coefs)

# Compute summary statistics of VAR coefficients without using coef()
summary_stats <- summary(mod$PHI)

# Test which list elements of 'mod' are of class 'bayesianVARs_draws'.
names(mod)[sapply(names(mod), function(x) inherits(mod[[x]], "bayesianVARs_draws"))]

}
\seealso{
Available extractors: \code{\link[=coef.bayesianVARs_bvar]{coef.bayesianVARs_bvar()}},
\code{\link[=vcov.bayesianVARs_bvar]{vcov.bayesianVARs_bvar()}}.
}
