% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_ARMA_coef.R
\name{sample_ARMA_coef}
\alias{sample_ARMA_coef}
\title{Sample ARMA coef}
\usage{
sample_ARMA_coef(
  order = c(0L, 0L),
  seasonal = list(order = c(0L, 0L), period = NA),
  n = 1,
  Mod_bounds = c(0.05, 0.95),
  min_inv_root_dist = 0
)
}
\arguments{
\item{order}{A specification of the non-seasonal part of the ARIMA model:
this is different than the \code{order} input of \code{\link[stats:arima]{stats::arima()}}, because
the degree of differencing is not included. Thus order is a vector of
length two of the form \eqn{(p, q)}.}

\item{seasonal}{A specification of the seasonal part of the ARIMA model. Can
be either a vector of length 2, or a list with an \code{order} component; if
a list, a period can be included, but it does not affect the function
output.}

\item{n}{An integer indicating how many sets of ARMA coefficients should be
sampled.}

\item{Mod_bounds}{Bounds on the magnitude of the roots.}

\item{min_inv_root_dist}{This parameter is included so as to help avoid ARMA
models that contain parameter redundancy, if desired. Specifically,
this parameter ensures that the minimum distance between any of the
inverted roots in the AR and MA polynomials is greater than
\code{min_inv_root_dist}. Inverted roots that are near each other leads to
canceling or nearly canceling roots, effectively reducing the size of the
ARMA model.}
}
\value{
a vector of randomly sampled ARMA coefficients.
}
\description{
This function randomly samples the ARMA coefficients of a specified
ARMA model. The coefficients are sampled so that the resulting ARMA model
is both causal and invertible.
}
\details{
For an ARMA model to be causal and invertible, the roots of the AR and MA
polynomials must lie outside the the complex unit circle. The AR and MA
polynomials are defined as:
\deqn{\phi(z) = 1 - \phi_1 z - \phi_2 z^2 - \ldots - \phi_p z^p}
\deqn{\theta(z) = 1 + \theta_1 z + \theta_2 z^2 + \ldots + \theta_q z^q}
where \eqn{z} is a complex number, \eqn{\phi_1, \ldots, \phi_p} are the
\eqn{p} AR coefficients of the ARMA model, and
\eqn{\theta_1, \ldots, \theta_p} are the \eqn{q} MA coefficients of the ARMA
model.

ARMA coefficients are sampled by sampling inverse roots to be inside the
complex unit circle, and then calculating the resulting polynomial.
To ensure that the resulting polynomial coefficients are real, we only sample
half of the needed number of complex roots, and set the remaining half to be
the complex conjugate of the sampled points. In the case where the number of
coefficients is odd, the remaining root is sampled uniformly, satisfying the
Mod_bounds parameter.
}
\examples{
{
sample_ARMA_coef(
   order = c(2, 1),
   seasonal = list(order = c(1, 0), period = 2),
   n = 100
)
}
}
