\name{XML2Obs}
\alias{XML2Obs}
\title{Parse XML files into a list of "observations"}
\usage{
XML2Obs(urls, xpath, append.value = TRUE, as.equiv = TRUE,
  url.map = FALSE, async = FALSE, quiet = FALSE)
}
\arguments{
  \item{urls}{character vector or list of urls that point
  to an XML file (or anything readable by
  \link{xmlParse}).}

  \item{xpath}{XML XPath expression that is passed to
  \link{getNodeSet}. If missing, the entire root and all
  descendents are captured and returned (ie, tables =
  "/").}

  \item{append.value}{logical. Should the XML value be
  appended for relevant observations?}

  \item{as.equiv}{logical. Should observations from two
  different files (but the same ancestory) have the same
  name returned?}

  \item{url.map}{logical. If TRUE, the 'url_key' column
  will contain a condensed url identifier (for each
  observation) and full urls will be stored in the
  "url_map" element. If FALSE, the full urls are included
  (for each observation) as a 'url' column and no "url_map"
  is included.}

  \item{async}{logical. Allows for asynchronous download
  requests. This option is passed to the \code{async}
  option in the \code{RCurl::getURL} function.}

  \item{quiet}{logical. Print file name currently being
  parsed?}
}
\value{
A list of "observations" and (possibly) the "url_map"
element.
}
\description{
This function takes a collection of urls that point to XML
files and coerces the relevant info into a list of
observations. An "observation" is defined as a matrix with
one row. An observation can also be thought of as a single
instance of XML attributes (and value) for a particular
level in the XML hierarchy. The names of the list reflect
the XML node ancestory for which each observation was
extracted from.
}
\details{
It's worth noting that a "url_key" column is appended to
each observation to help track the origin of each
observation. The value of the "url_key" column is not the
actual file name, but a simplified identifier to avoid
unnecessarily repeating long file names for each
observation. For this reason, an addition element (named
"url_map") is added to the list of observations in case the
actual file named want to be used.
}
\examples{
\dontrun{
urls <- c("http://gd2.mlb.com/components/game/mlb/year_2013/mobile/346180.xml",
           "http://gd2.mlb.com/components/game/mlb/year_2013/mobile/346188.xml")
obs <- XML2Obs(urls)
table(names(obs))
}
}
\seealso{
\link{urlsToDocs}, \link{docsToNodes}, \link{nodesToList},
\link{listsToObs}
}

