% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wals.R
\name{predict.wals}
\alias{predict.wals}
\alias{predict.walsMatrix}
\alias{fitted.wals}
\alias{residuals.wals}
\alias{print.wals}
\alias{summary.wals}
\alias{print.summary.wals}
\alias{coef.wals}
\alias{vcov.wals}
\alias{nobs.wals}
\alias{terms.wals}
\alias{model.matrix.wals}
\title{Methods for wals and walsMatrix Objects}
\usage{
\method{predict}{wals}(object, newdata, na.action = na.pass, ...)

\method{predict}{walsMatrix}(object, newX1, newX2, ...)

\method{fitted}{wals}(object, ...)

\method{residuals}{wals}(object, ...)

\method{print}{wals}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{wals}(object, ...)

\method{print}{summary.wals}(x, digits = max(3, getOption("digits") - 3), ...)

\method{coef}{wals}(object, type = c("all", "focus", "aux"), transformed = FALSE, ...)

\method{vcov}{wals}(object, type = c("all", "focus", "aux"), transformed = FALSE, ...)

\method{nobs}{wals}(object, ...)

\method{terms}{wals}(x, type = c("focus", "aux"), ...)

\method{model.matrix}{wals}(object, type = c("focus", "aux"), ...)
}
\arguments{
\item{object, x}{An object of class \code{"wals"}, \code{"walsMatrix"} or
\code{"summary.wals"}.}

\item{newdata}{Optionally, a data frame in which to look for variables with
which to predict. If omitted, the original observations are used.}

\item{na.action}{Function determining what should be done with missing values
in \code{newdata}. The default is to predict \code{NA}.}

\item{...}{Further arguments passed to methods.}

\item{newX1}{Focus regressors matrix to be used for the prediction.}

\item{newX2}{Auxiliary regressors matrix to be used for the prediction.}

\item{digits}{The number of significant digits to display.}

\item{type}{Character specifying the part of the model that should be returned.
For details see below.}

\item{transformed}{Logical specifying whether the coefficients/covariance
matrix of original regressors (\code{FALSE}, default) or the transformed
regressors (\code{TRUE}) should be returned.}
}
\value{
\code{predict.wals()} and \code{predict.walsMatrix()} return a vector
containing the predicted means.

\code{fitted.wals()} returns a vector containing the fitted means
for the data used in fitting.

\code{residuals.wals()} returns the raw residuals of the fitted
model, i.e. response - fitted mean.

\code{print.wals()} invisibly returns its input argument \code{x},
i.e. an object of object of class \code{"wals"}.

\code{summary.wals} returns an object of class \code{"summary.wals"}
which contains the necessary fields for printing the summary in
\code{print.summary.wals()}.

\code{print.summary.wals()} invisibly returns its input argument
\code{x}, i.e. an object of object of class \code{"summary.wals"}.

\code{coef.wals()} returns a vector containing the fitted coefficients.
If \code{type = "focus"}, only the coefficients of the focus regressors are
returned and if \code{type = "aux"}, only the coefficients of auxiliary
regressors are returned. Else if \code{type = "all"}, the coefficients
of both focus and auxiliary regressors are returned. Additionally if
\code{transformed = FALSE}, \code{coef.wals()} returns the estimated
coefficients for the original regressors \eqn{X} (\eqn{\beta} coefficients)
and else if \code{transformed = TRUE} the coefficients of the transformed
regressors \eqn{Z} (\eqn{\gamma} coefficients).

\code{vcov.wals()} returns a matrix containing the estimated
(co-)variances of the fitted regression coefficients. If \code{type = "focus"},
only the submatrix belonging to the focus regressors is returned and if
\code{type = "aux"}, only the submatrix corresponding to the auxiliary
regressors is returned. Else if \code{type = "all"}, the complete covariance
matrix is returned. Additionally if \code{transformed = FALSE},
\code{vcov.wals()} returns the estimated covariance matrix for the original
regressors \eqn{X} (\eqn{\beta} coefficients) and else if
\code{transformed = TRUE} the covariance matrix of the transformed regressors
\eqn{Z} (\eqn{\gamma} coefficients).

\code{nobs.wals()} returns the number of observations used for
fitting the model.

\code{terms.wals()} returns the \emph{terms} representation of the fitted
model. It is of class \code{c("terms", "formula")}, see \code{\link[stats]{terms}}
and \code{\link[stats]{terms.object}} for more details. If \code{type = "focus"},
then returns the terms for the focus regressors, else if \code{type = "aux"}
returns the terms for the auxiliary regressors.

\code{model.matrix.wals()} either returns the design matrix of the
focus regressors (\code{type = "focus"}) or of the auxiliary regressors
(\code{type = "aux"}). See \code{\link[stats]{model.matrix}} for more details.
}
\description{
Methods for extracting information from fitted model-averaging objects of
classes \code{"wals"} and \code{"walsMatrix"}. \code{"walsMatrix"} objects
inherit from \code{"wals"}, so the methods for \code{"wals"} also work for
objects of class \code{"walsMatrix"}.
}
\details{
A set of standard extractor functions for fitted model objects is available
for objects of class \code{"wals"} and \code{"walsMatrix"}, including methods to
the generic functions \code{\link[base]{print}} and \code{\link[base]{summary}}
which print the model-averaged estimation of the coefficients along with some
further information. As usual, the \code{summary} method returns an object of
class \code{"summary.wals"} containing the relevant summary statistics which
can then be printed using the associated \code{print} method.
Inspired by \insertCite{deluca2011stata;textual}{WALS},the summary statistics
also show \code{Kappa} which is an indicator for the numerical stability of
the method, i.e. it shows the square root of the condition number of the
matrix \eqn{\Xi = \Delta_{2} X_{2}^{\top} M_{1} X_{2} \Delta_{2}}.
The summary further provides information on the prior used along with its
parameters.

The \code{\link[stats]{residuals}} method computes raw residuals
(observed - fitted).

For \code{\link[stats]{coef}} and \code{\link[stats]{vcov}}, the \code{type}
argument, either \code{"all"}, \code{"focus"} or \code{"aux"}, specifies which
part of the coefficient vector/covariance matrix of the estimates should be
returned. Additionally, the \code{transformed} argument specifies whether to
return the estimated  coefficients/covariance matrix for the original
regressors \eqn{X} or of the transformed regressors \eqn{Z}.

The extractors \code{\link[stats]{terms}} and \code{\link[stats]{model.matrix}}
behave similarly to \code{coef}, but they only allow \code{type = "focus"}
and \code{type = "aux"}. They extract the corresponding component of the model.
}
\examples{
## Example for wals objects
fitGrowth <- wals(gdpgrowth ~ lgdp60 + equipinv + school60 + life60 + popgrowth |
                law + tropics + avelf + confucian, data = GrowthMPP,
                prior = laplace())
summary(fitGrowth)
fitted(fitGrowth)
vcov(fitGrowth, type = "aux")
familyPrior(fitGrowth)
nobs(fitGrowth)

## Example for walsMatrix objects
X1 <- model.matrix(fitGrowth, type = "focus")
X2 <- model.matrix(fitGrowth, type = "aux")
y <- GrowthMPP$gdpgrowth
fitGrowthMatrix <- wals(X1, X2, y, prior = laplace())
coef(fitGrowthMatrix)

}
\references{
\insertAllCited{}
}
\seealso{
\link{wals}
}
