% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{gammaToBeta}
\alias{gammaToBeta}
\title{Internal function: Transform gammas back to betas}
\usage{
gammaToBeta(
  posterior,
  y,
  Z1,
  Z2,
  Delta1,
  D2,
  sigma,
  Z1inv,
  method = "original",
  svdZ1
)
}
\arguments{
\item{posterior}{Object returned from \code{\link[WALS]{computePosterior}}.}

\item{y}{Response \eqn{y}.}

\item{Z1}{Transformed focus regressors \eqn{Z_1}.}

\item{Z2}{Transformed auxiliary regressors \eqn{Z_1}.}

\item{Delta1}{\eqn{\Delta_1} or \eqn{\bar{\Delta}_1}.}

\item{D2}{From \code{\link[WALS]{semiorthogonalize}}, if \code{postmult = FALSE}
was used, then D2 = \eqn{\Delta_2 T \Lambda^{-1/2}}, where \eqn{T} are the
eigenvectors of \eqn{\Xi} and \eqn{\Lambda} the diagonal matrix containing
the corresponding eigenvalues. If \code{postmult = TRUE} was used, then
D2 = \eqn{\Delta_2 T \Lambda^{-1/2} T' = \Delta_2 \Xi^{-1/2}}.}

\item{sigma}{Prespecified or estimated standard error of the error term.}

\item{Z1inv}{\eqn{(Z_{1}' Z_{1})^{-1}}.}

\item{method}{Character. \eqn{\hat{\gamma}_1} is obtained from a linear
regression of \eqn{Z_1} on pseudo-responses \eqn{y - Z_2 \hat{\gamma}_2}.
If \code{method = original}, then we use \code{\link[stats]{lm.fit}} to perform
the linear regression, if \code{method = "svd"}, then reuse the SVD of
\eqn{Z_1} in \code{svdZ1} to perform the regression.}

\item{svdZ1}{Optional, only needed if \code{method = "svd"}. SVD of \eqn{Z_1}
computed using \code{\link[base]{svd}}.}
}
\description{
Transforms posterior means \eqn{\hat{\gamma}_2} and variances corresponding
to transformed auxiliary regressors \eqn{Z_2} back to regression coefficients
\eqn{\hat{\beta}} of original regressors \eqn{X_1} and \eqn{X_2}.
}
\details{
The same transformations also work for GLMs, where we replace \eqn{X_1},
\eqn{X_2}, \eqn{Z_1} and \eqn{Z_2} with \eqn{\bar{X}_1}, \eqn{\bar{X}_2},
\eqn{\bar{Z}_1} and \eqn{\bar{Z}_2}, respectively. Generally, we need to
replace all variables with their corresponding "bar" version. Further,
for GLMs \code{sigma} is always 1.

See \insertCite{magnus2016wals;textual}{WALS}, \insertCite{deluca2018glm;textual}{WALS}
and \insertCite{huynhwals;textual}{WALS} for the definitions of the variables.
}
\references{
\insertAllCited{}
}
