% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_rtrunc.R, R/beta.R, R/binomial.R, R/chisq.R,
%   R/contbernoulli.R, R/exponential.R, R/gamma.R, R/inverse-gamma.R,
%   R/inverse-gaussian.R, R/log-normal.R, R/negative-binomial.R, R/normal.R,
%   R/poisson.R, R/rtrunc_direct.R
\name{rtrunc}
\alias{rtrunc}
\alias{rtrunc.beta}
\alias{rtruncbeta}
\alias{rtruncbinom}
\alias{rtruncchisq}
\alias{rtrunccontbern}
\alias{rtruncexp}
\alias{rtruncgamma}
\alias{rtruncinvgamma}
\alias{rtruncinvgauss}
\alias{rtrunclnorm}
\alias{rtruncnbinom}
\alias{rtruncnorm}
\alias{rtruncpois}
\alias{rtrunc_direct}
\title{The Truncated Exponential Family}
\usage{
rtrunc(n, family = "gaussian", faster = FALSE, ...)

rtrunc.beta(n, shape1, shape2, a = 0, b = 1)

rtruncbeta(n, shape1, shape2, a = 0, b = 1)

rtruncbinom(n, size, prob, a = 0, b = size)

rtruncchisq(n, df, a = 0, b = Inf)

rtrunccontbern(n, lambda, a = 0, b = 1)

rtruncexp(n, rate = 1, a = 0, b = Inf)

rtruncgamma(n, shape, rate = 1, scale = 1/rate, a = 0, b = Inf)

rtruncinvgamma(n, shape, rate = 1, scale = 1/rate, a = 0, b = Inf)

rtruncinvgauss(n, m, s, a = 0, b = Inf)

rtrunclnorm(n, meanlog, sdlog, a = 0, b = Inf)

rtruncnbinom(n, size, prob, mu, a = 0, b = Inf)

rtruncnorm(n, mean, sd, a = -Inf, b = Inf)

rtruncpois(n, lambda, a = 0, b = Inf)

rtrunc_direct(n, family = "gaussian", ...)
}
\arguments{
\item{n}{sample size}

\item{family}{distribution family to use}

\item{faster}{if \code{TRUE}, samples directly from the truncated
distribution (more info in details)}

\item{...}{individual arguments to each distribution}

\item{shape1}{positive shape parameter alpha}

\item{shape2}{positive shape parameter beta}

\item{a}{point of left truncation}

\item{b}{point of right truncation}

\item{size}{target for number of successful trials,
or dispersion parameter (the shape parameter of the gamma mixing
distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success on each trial}

\item{df}{degrees of freedom for "parent" distribution}

\item{lambda}{mean and var of "parent" distribution}

\item{rate}{inverse gamma rate parameter}

\item{shape}{inverse gamma shape parameter}

\item{scale}{inverse gamma scale parameter}

\item{m}{vector of means}

\item{s}{vector of dispersion parameters}

\item{meanlog}{mean of un-truncated distribution}

\item{sdlog}{standard deviation of un-truncated distribution}

\item{mu}{alternative parametrization via mean}

\item{mean}{mean of parent distribution}

\item{sd}{standard deviation is parent distribution}
}
\value{
A sample of size n drawn from a truncated distribution

vector of one of the \code{rtrunc_*} classes containing the sample
elements, as well as some attributes related to the chosen distribution.
}
\description{
Random generation for the truncated exponential family
distributions. Please ferer to the "Details" and "Examples" section for more
information on how to use this function.
}
\details{
One way to use this function is by calling the \code{rtrunc}
generic with the \code{family} parameter of your choice. You can also
specifically call one of the methods (e.g. \code{rtruncpois(10, lambda=3)}
instead of `rtrunc(10, family="poisson", lambda=3)). The latter is more
flexible (i.e., easily programmable) and more robust (i.e., it contains
better error handling and validation procedures), while the former better
conforms with the nomenclature from other distribution-related functions in
the \code{stats} package.

Setting \code{faster=TRUE} uses a new algorithm that samples directly from
the truncated distribution, as opposed to the old algorithm that samples
from the untruncated distribution and then truncates the result. The
advantage of the new algorithm is that it is way faster than the old one,
particularly for highly-truncated distributions. On the other hand, the
sample for untruncated distributions called through \code{rtrunc()} will no longer
match their \code{stats}-package counterparts for the same seed.
}
\note{
The current sample-generating algorithm may be slow if the distribution
is largely represented by low-probability values. This will be fixed soon.
Please follow \url{https://github.com/ocbe-uio/TruncExpFam/issues/72} for
details.
}
\examples{
# Truncated binomial distribution
sample.binom <- rtrunc(
  100, family = "binomial", prob = 0.6, size = 20, a = 4, b = 10
)
sample.binom
plot(
  table(sample.binom), ylab = "Frequency", main = "Freq. of sampled values"
)

# Truncated Log-Normal distribution
sample.lognorm <- rtrunc(
  n = 100, family = "lognormal", meanlog = 2.5, sdlog = 0.5, a = 7
)
summary(sample.lognorm)

hist(
  sample.lognorm,
  nclass = 35, xlim = c(0, 60), freq = FALSE,
  ylim = c(0, 0.15)
)

# Normal distribution
sample.norm <- rtrunc(n = 100, mean = 2, sd = 1.5, a = -1)
head(sample.norm)
hist(sample.norm, nclass = 25)

# Gamma distribution
sample.gamma <- rtrunc(n = 100, family = "gamma", shape = 6, rate = 2, a = 2)
hist(sample.gamma, nclass = 15)

# Poisson distribution
sample.pois <- rtrunc(n = 10, family = "poisson", lambda = 10, a = 4)
sample.pois
plot(table(sample.pois))
}
\author{
René Holst, Waldir Leôncio
}
