% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs_of.R
\name{inputs_of}
\alias{inputs_of}
\title{Inputs to files nested within LaTeX document}
\usage{
inputs_of(filename, exclude.preamble = TRUE, append.tex = TRUE)
}
\arguments{
\item{filename}{The file whose \code{\\inputs} are to be extracted.}

\item{exclude.preamble}{(logical) If \code{TRUE}, the default, only \code{\\input}s and \code{\\include}s within the \code{document} environment are returned.}

\item{append.tex}{Should the result include the file extension \code{.tex}? By default, \code{TRUE}. Setting to \code{FALSE} may be useful when the file is not a \code{.tex} file.}
}
\value{
A character vector of file paths relative to \code{filename} that are
 used as \code{\\input}s or \code{\\include}s within \code{filename}. If 
 no such files are present within \code{filename}, \code{NULL} is returned.
}
\description{
Inputs to files nested within LaTeX document
}
