% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Structstrings.R,
%   R/Structstrings-DotBracketDataFrame.R, R/Structstrings-DotBracketString.R,
%   R/Structstrings-DotBracketStringSet.R
\docType{data}
\name{Structstrings-internals}
\alias{Structstrings-internals}
\alias{DOTBRACKET_CHAR_VALUES}
\alias{DOTBRACKET_ALPHABET}
\alias{STRUCTURE_NEUTRAL_CHR}
\alias{STRUCTURE_OPEN_CHR}
\alias{STRUCTURE_CLOSE_CHR}
\alias{[<-,DotBracketDataFrame-method}
\alias{colnames<-,CompressedSplitDotBracketDataFrameList-method}
\alias{seqtype,DotBracketString-method}
\alias{subseq,DotBracketString-method}
\alias{subseq<-,DotBracketString-method}
\alias{subseq<-,DotBracketStringSet-method}
\title{Structstrings internals}
\format{
a \code{integer} vector of length 9 containing the integer values
of the dotbracket alphabet

a \code{character} vector of length 9 containing the single 
characters of the dotbracket alphabet

a \code{character} vector of length 1 containing the character for
unpaired positions

a \code{character} vector of length 4 containing the opening 
character of the dotbracket alphabet

a \code{character} vector of length 4 containing the closing 
character of the dotbracket alphabet
}
\usage{
DOTBRACKET_CHAR_VALUES

DOTBRACKET_ALPHABET

STRUCTURE_NEUTRAL_CHR

STRUCTURE_OPEN_CHR

STRUCTURE_CLOSE_CHR

\S4method{[}{DotBracketDataFrame}(x, i, j, ...) <- value

\S4method{colnames}{CompressedSplitDotBracketDataFrameList}(x) <- value

\S4method{seqtype}{DotBracketString}(x)

\S4method{subseq}{DotBracketString}(x, start = NA, end = NA, width = NA)

\S4method{subseq}{DotBracketString}(x, start = NA, end = NA, width = NA) <- value

\S4method{subseq}{DotBracketStringSet}(x, start = NA, end = NA, width = NA) <- value
}
\arguments{
\item{seqtype, x, start, end, width, value, i, j, ...}{used internally}
}
\description{
Analog to \code{Biostrings} there are a few objects, which should only be 
used internally, but may be of use to other package developers.
Otherwise take care.
}
\examples{
DOTBRACKET_CHAR_VALUES
DOTBRACKET_ALPHABET
STRUCTURE_NEUTRAL_CHR
STRUCTURE_OPEN_CHR
STRUCTURE_CLOSE_CHR

# the replace method for a DotBracketDataFrame had to be reimplemented
# because of the requirement of columns for a DotBracketDataFrameList and
# DotBracketDataFrame
data("dbs", package = "Structstrings")
dbdfl <- getBasePairing(dbs)
# Elements are returned as DotBracketDataFrames
dbdf <- dbdfl[[1]]
dbdfl[[1]] <- dbdf
dbdfl[1] <- dbdfl[1]
}
\keyword{datasets}
