% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Structstrings-DotBracket-io.R
\name{DotBracketStringSet-io}
\alias{DotBracketStringSet-io}
\alias{readDotBracketStringSet}
\alias{writeDotBracketStringSet}
\alias{saveDotBracketStringSet}
\title{Reading and writing DotBracketStringSet objects}
\usage{
readDotBracketStringSet(
  filepath,
  format = "fasta",
  nrec = -1L,
  skip = 0L,
  seek.first.rec = FALSE,
  use.names = TRUE,
  with.qualities = FALSE
)

writeDotBracketStringSet(
  x,
  filepath,
  append = FALSE,
  compress = FALSE,
  format = "fasta",
  ...
)

saveDotBracketStringSet(
  x,
  objname,
  dirpath = ".",
  save.dups = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filepath}{The file name, when writing, or file name(s) when reading.}

\item{format}{"fasta" or "fastq"}

\item{nrec}{Single integer. The maximum of number of records to read in. 
Negative values are ignored.}

\item{skip}{Single non-negative integer. The number of records of the data 
file(s) to skip before beginning to read in records.}

\item{seek.first.rec, with.qualities, compress, ..., use.names, objname, dirpath, save.dups, verbose}{Have a look \code{\link[Biostrings:XStringSet-io]{here}}.}

\item{x}{A DotBracketStringSet object}

\item{append}{\code{TRUE} or \code{FALSE}. If \code{TRUE} output will be 
appended to file. Otherwise, it will overwrite the contents of file.}
}
\value{
\code{readDotBracketStringSet} returns a \code{DotBracketStringSet}
object, \code{writeDotBracketStringSet} returns \code{NULL} invisibly.
}
\description{
\code{readDotBracketStringSet} and \code{writeDotBracketStringSet} are 
functions to read and write dot bracket strings from/to file. Since the
\code{<>} is in conflict with the fasta format, saving to fastq file is
sometimes the only option. Saving a string with a \code{<>} bracket type to a
fasta file will throw an error.

The functions use the underlying \code{Biostrings} infrastructure and share
most of its parameters. For a more detailed look have a look 
\code{\link[Biostrings:XStringSet-io]{here}}.
}
\examples{
data("dbs", package = "Structstrings")
file <- tempfile()
# works both since a DotBracketStringSet is a BStringSet
writeXStringSet(dbs,file)
writeDotBracketStringSet(dbs,file)
# to return immediatly a DotBracketStringSet us readDotBracketStringSet()
dbs2 <- readDotBracketStringSet(file)
}
