% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{bcaconfvalues}
\alias{bcaconfvalues}
\title{BCa confidence intervals}
\usage{
bcaconfvalues(bootreps, popest, ahat, alpha = c(0.025, 0.05, 0.1, 0.16,
  0.84, 0.9, 0.95, 0.975))
}
\arguments{
\item{bootreps}{Point estimates of total population sizes from each bootstrap sample.}

\item{popest}{A point estimate of the total population of the original data set.}

\item{ahat}{the estimated acceleration factor}

\item{alpha}{Bootstrap quantiles of interests}
}
\value{
BCa confidence intervals
}
\description{
The BCa confidence intervals use percentiles of the bootstrap distribution of the population size
, but adjust the percentile actually used. The adjusted percentiles depend on an
estimated bias parameter, and the quantile function of the estimated bias parameter is the proportion
of the bootstrap estimates that fall below the estimate from the original data, and an
estimated acceleration factor, which derivation depends on a jackknife approach. This routine is called internally
by \code{estimatepopulation}.
}
\references{
Chan, L., Silverman, B. W., and Vincent, K. (2019).
 Multiple Systems Estimation for Sparse Capture Data: Inferential Challenges when there are Non-Overlapping Lists.
  Available from \url{https://arxiv.org/abs/1902.05156}.

DiCiccio, T. J. and Efron, B. (1996). Bootstrap Confidence Intervals. \emph{Statistical Science}, \strong{40(3)}, 189-228.
}
