% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiOmicsSmCCA.R
\name{getCanWeightsMulti}
\alias{getCanWeightsMulti}
\title{Get Canonical Weight SmCCA Algorithm (No Subsampling)}
\usage{
getCanWeightsMulti(
  X,
  Trait = NULL,
  Lambda,
  CCcoef = NULL,
  NoTrait = TRUE,
  trace = FALSE,
  TraitWeight = FALSE
)
}
\arguments{
\item{X}{A list of omics data each with n subjects.}

\item{Trait}{An \eqn{n} by 1 trait (phenotype) data for the same samples.}

\item{Lambda}{Lasso penalty vector with length equals to the number of omics data (\eqn{X}). \code{Lambda} needs
to be between 0 and 1.}

\item{CCcoef}{Optional scaling factors for the SmCCA pairwise canonical
correlations. If \code{CCcoef = NULL} (default), then the objective function
is the total sum of all pairwise canonical correlations. It follows the column order of \code{combn(T+1, 2)}, where \code{T} is the total number of omics data.}

\item{NoTrait}{Whether or not trait (phenotype) information is provided, default is set to \code{TRUE}.}

\item{trace}{Whether to display CCA algorithm trace, default is set to \code{FALSE}.}

\item{TraitWeight}{Whether to return canonical weight for trait (phenotype), default is set to \code{FALSE}.}
}
\value{
A canonical weight vector with size of \eqn{p} by 1.
}
\description{
Run Sparse multiple Canonical Correlation Analysis (SmCCA) and return
canonical weight vectors.
}
\examples{
# This function is typically used as an internal function.
# It is also used when performing cross-validation,
# refer to multi-omics vignette for more detail.
# X <- list(X1,X2)
# result <- getCanWeightsMulti(X, Trait = as.matrix(Y), Lambda = c(0.5,0.5), NoTrait = FALSE)
# result <- getCanWeightsMulti(X, Trait = NULL, Lambda = c(0.5,0.5), NoTrait = TRUE)
# cccoef <- c(1,10,10)
# result <- getCanWeightsMulti(X, Trait = as.matrix(Y), CCcoef = cccoef, 
#                              Lambda = c(0.5,0.5), NoTrait = FALSE)
}
