% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{EmptyMatrix}
\alias{EmptyMatrix}
\title{Empty Matrices}
\usage{
EmptyMatrix(repr = "C", type = "d")
}
\arguments{
\item{repr}{Representation of empty matrix; choose from:
\itemize{
 \item \dQuote{\code{C}} for a
  \code{\link[Matrix:CsparseMatrix-class]{CsparseMatrix}}
 \item \dQuote{\code{T}} for a
  \code{\link[Matrix:TsparseMatrix-class]{TsparseMatrix}}
 \item \dQuote{\code{R}} for an
  \code{\link[Matrix:RsparseMatrix-class]{RsparseMatrix}}
 \item \dQuote{\code{e}} for an
  \code{\link[Matrix:unpackedMatrix-class]{unpackedMatrix}}
 \item \dQuote{\code{d}} for a dense S3 \code{\link[base]{matrix}}
 \item \dQuote{\code{spam}} for a \code{\link[spam]{spam}} matrix
}}

\item{type}{Type of resulting matrix to return, choose from:
\itemize{
 \item \dQuote{\code{d}} for numeric matrices
 \item \dQuote{\code{l}} for logical matrices
 \item \dQuote{\code{n}} for pattern matrices
}
Note, when \code{repr} is \dQuote{\code{spam}}, \code{type} must be
\dQuote{\code{d}}; when \code{repr} is \dQuote{\code{d}}, setting \code{type}
to \dQuote{\code{n}} returns a logical matrix}
}
\value{
A 0x0 matrix of the specified representation and type
}
\description{
Create empty 0x0 matrices of varying types
}
\examples{
EmptyMatrix()
EmptyMatrix("spam")

}
\seealso{
\code{\link{IsMatrixEmpty}()}
}
\concept{utils}
