% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindSQLDataFrame.R
\name{rbind}
\alias{rbind}
\alias{rbind,SQLDataFrame-method}
\title{rbind of \code{SQLDataFrame} objects}
\usage{
\S4method{rbind}{SQLDataFrame}(..., deparse.level = 1)
}
\arguments{
\item{...}{One or more \code{SQLDataFrame} objects. These can be
given as named arguments.}

\item{deparse.level}{See ‘?base::cbind’ for a description of this
argument.}
}
\value{
A \code{SQLDataFrame} object.
}
\description{
Performs rbind on \code{SQLDataFrame} objects.
}
\details{
\code{rbind} supports aggregation of SQLDataFrame
    objects. For representation of SQLite tables, same or different
    connections are supported. For representation of MySQL tables,
    at least one SQLDataFrame must have write permission.
}
\examples{
test.db1 <- system.file("extdata/test.db", package = "SQLDataFrame")
test.db2 <- system.file("extdata/test1.db", package = "SQLDataFrame")
con1 <- DBI::dbConnect(DBI::dbDriver("SQLite"), dbname = test.db1)
con2 <- DBI::dbConnect(DBI::dbDriver("SQLite"), dbname = test.db2)
obj1 <- SQLDataFrame(conn = con1,
                     dbtable = "state",
                     dbkey = c("region", "population"))
obj2 <- SQLDataFrame(conn = con2,
                     dbtable = "state1",
                     dbkey = c("region", "population"))
obj1_sub <- obj1[1:10, 2:3]
obj2_sub <- obj2[8:15,2:3]

## rbind
res_rbind <- rbind(obj1_sub, obj2_sub)
res_rbind
dim(res_rbind)
}
