% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform.like.R
\name{uniform.like}
\alias{uniform.like}
\title{uniform.like - Uniform distance likelihood}
\usage{
uniform.like(
  a,
  dist,
  covars = NULL,
  w.lo = 0,
  w.hi = max(dist),
  series = "cosine",
  expansions = 0,
  scale = TRUE,
  pointSurvey = FALSE
)
}
\arguments{
\item{a}{A vector of likelihood parameter values. Length and meaning 
depend on whether covariates and \code{expansions} are present as follows:
\itemize{
   \item If no covariates and no expansions: \code{a} = [a, b] (see Details)
   \item If no covariates and \emph{k} expansions: \code{a} = [a, b, e1, ..., e\emph{k}] 
   \item If \emph{p} covariates and no expansions: \code{a} = [a, b, b1, ..., b\emph{p}] 
   \item If \emph{p} covariates and \emph{k} expansions: \code{a} = [a, b, b1, ..., b\emph{p}, e1, ..., e\emph{k}] 
}}

\item{dist}{A numeric vector containing observed distances with measurement
units.}

\item{covars}{Data frame containing values of covariates at 
each observation in \code{dist}.}

\item{w.lo}{Scalar value of the lowest observable distance, with measurement
units.  
This is the \emph{left truncation} sighting distance.  Values less than 
\code{w.lo} are allowed in \code{dist}, but are ignored and 
their likelihood value is set to
 \code{NA} in the output.}

\item{w.hi}{Scalar value of the largest observable distance, with measurement
units.  
This is the \emph{right truncation} sighting distance.
Values greater than \code{w.hi} are allowed in \code{dist}, 
but are ignored and their likelihood value is 
set to \code{NA} in the output.}

\item{series}{A string specifying the type of expansion to 
use.  Currently, valid values are 'simple', 'hermite', and 
'cosine'; but, see \code{\link{dfuncEstim}} about 
defining other series.}

\item{expansions}{A scalar specifying the number of terms 
in \code{series}. Depending on the series, this could be 0 through 5.
The default of 0 equates to no expansion terms of any type.}

\item{scale}{Logical scalar indicating whether or not to scale 
the likelihood into a density function, i.e., so that it integrates 
to 1. This parameter is used 
to stop recursion in other functions.
If \code{scale} equals TRUE, a numerical integration 
routine (\code{\link{integration.constant}}) is called, which 
in turn calls this likelihood function again
with \code{scale} = FALSE. Thus, this routine knows when its 
values are being used to compute the likelihood and when its 
values are being used to compute the constant of integration.  
All user defined likelihoods must have and use this parameter.}

\item{pointSurvey}{Boolean. TRUE if \code{dist} is point 
transect data, FALSE if line transect data.}
}
\value{
A numeric vector the same length and order as \code{dist} 
containing the likelihood contribution for corresponding distances 
in \code{dist}. 
Assuming \code{L} is the returned vector, 
the log likelihood of all data is \code{-sum(log(L), na.rm=T)}. 
Note that the returned likelihood value for distances less than 
\code{w.lo} or greater than \code{w.hi} is \code{NA}, and thus it is 
essential to use \code{na.rm=TRUE} in the sum. If \code{scale} = TRUE, 
the integral of the likelihood from \code{w.lo} to \code{w.hi} is 1.0. 
If \code{scale} = FALSE, the integral of the likelihood is
arbitrary.
}
\description{
Compute uniform-like distribution for 
distance functions.  This function was present in \code{Rdistance}
version < 2.2.0.  It has been replaced by the more appropriately named
\code{\link{logistic.like}}.
}
\section{Expansion Terms}{


If \code{expansions} = k (k > 0), the 
expansion function specified by \code{series} is called (see for example
\code{\link{cosine.expansion}}). Assuming 
\eqn{h_{ij}(x)}{h_ij(x)} is the \eqn{j^{th}}{j-th} expansion term 
for the \eqn{i^{th}}{i-th} distance and that 
\eqn{c_1, c_2, \dots, c_k}{c(1), c(2), ..., c(k)} are (estimated) 
coefficients, the likelihood contribution 
for the \eqn{i^{th}}{i-th} distance is, 
\deqn{f(x|a,b,c_1,c_2,\dots,c_k) = f(x|a,b)(1 + 
\sum_{j=1}^{k} c_j h_{ij}(x)).}{%
f(x|a,b,c_1,c_2,...,c_k) = f(x|a,b)(1 + c(1) h_i1(x) + 
c(2) h_i2(x) + ... + c(k) h_ik(x)). }
}

