% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RaggedExperiment-pkg.R
\docType{package}
\name{RaggedExperiment-package}
\alias{RaggedExperiment-package}
\title{RaggedExperiment: Range-based data representation package}
\description{
\link{RaggedExperiment} allows the user to represent, copy
    number, mutation, and other types of range-based data formats
    where optional information about samples can be provided. At
    the backbone of this package is the \linkS4class{GRangesList}
    class. The RaggedExperiment class uses this representation
    and presents the data in a couple of different ways:
    \itemize{
    \item rowRanges
    \item colData
    }
    The \link{rowRanges} method will return the internal
    \code{GRangesList} representation of the dataset. A distinction
    between the \linkS4class{SummarizedExperiment} and the
    \code{RaggedExperiment} classes is that the \link{RaggedExperiment}
    class allows for ragged ranges, meaning that there may be a
    different number of ranges or rows per sample.
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://github.com/Bioconductor/RaggedExperiment/issues}
}

}
\author{
\strong{Maintainer}: Martin Morgan \email{martin.morgan@roswellpark.org}

Authors:
\itemize{
  \item Marcel Ramos \email{marcel.ramos@roswellpark.org} (\href{https://orcid.org/0000-0002-3242-0582}{ORCID})
}

}
