% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.Exponential.R
\name{Exponential}
\alias{Exponential}
\title{Exponential}
\description{
Exponential distribution in OOP way. Based on AbstractDist
}
\details{
See AbstractDist for generic methods
}
\examples{
## Generate sample
rate = 0.5
expl = ROOPSD::Exponential$new( rate = rate )
X    = expl$rvs( n = 1000 )

## And fit parameters
expl$fit(X)

}
\section{Super class}{
\code{\link[ROOPSD:AbstractDist]{ROOPSD::AbstractDist}} -> \code{Exponential}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rate}}{[double] rate of the exponential law}

\item{\code{params}}{[vector] params of the exponential law}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Exponential-new}{\code{Exponential$new()}}
\item \href{#method-Exponential-clone}{\code{Exponential$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="cdf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-cdf'><code>ROOPSD::AbstractDist$cdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="density"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-density'><code>ROOPSD::AbstractDist$density()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="diagnostic"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-diagnostic'><code>ROOPSD::AbstractDist$diagnostic()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="fit"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-fit'><code>ROOPSD::AbstractDist$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="icdf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-icdf'><code>ROOPSD::AbstractDist$icdf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="isf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-isf'><code>ROOPSD::AbstractDist$isf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="logdensity"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-logdensity'><code>ROOPSD::AbstractDist$logdensity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="pdeltaCI"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-pdeltaCI'><code>ROOPSD::AbstractDist$pdeltaCI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="qdeltaCI"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-qdeltaCI'><code>ROOPSD::AbstractDist$qdeltaCI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="qgradient"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-qgradient'><code>ROOPSD::AbstractDist$qgradient()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="rvs"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-rvs'><code>ROOPSD::AbstractDist$rvs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ROOPSD" data-topic="AbstractDist" data-id="sf"><a href='../../ROOPSD/html/AbstractDist.html#method-AbstractDist-sf'><code>ROOPSD::AbstractDist$sf()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exponential-new"></a>}}
\if{latex}{\out{\hypertarget{method-Exponential-new}{}}}
\subsection{Method \code{new()}}{
Create a new Exponential object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exponential$new(rate = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rate}}{[double] Rate of the exponential law}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Exponential` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exponential-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Exponential-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exponential$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
