% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_misc.R
\name{computeSimilarityVar}
\alias{computeSimilarityVar}
\alias{computeSimilarityClass}
\title{Similarity}
\usage{
computeSimilarityVar(outMixtComp)

computeSimilarityClass(outMixtComp)
}
\arguments{
\item{outMixtComp}{object of class \emph{MixtCompLearn} or \emph{MixtComp} obtained using \code{mixtCompLearn} or \code{mixtCompPredict} functions from \code{RMixtComp} package or \code{rmcMultiRun} from \code{RMixtCompIO} package.}
}
\value{
a similarity matrix
}
\description{
Compute the similarity between variables (or classes)
}
\details{
The similarities between variables j and h is defined by Delta(j,h)
\deqn{Delta(j,h)^2 = 1 - \sqrt{(1/n) * \sum_{i=1}^n \sum_{k=1}^K (P(Z_i=k|x_{ij}) - P(Z_i=k|x_{ih}))^2}}

The similarities between classes k and g is defined by 1 - Sigma(k,g)
\deqn{Sigma(k,g)^2 = (1/n) * \sum_{i=1}^n (P(Z_i=k|x_i) - P(Z_i=g|x_i))^2}
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(
  var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
  var2 = as.character(c(rnorm(50, 2), rpois(50, 8)))
)

model <- list(
  var1 = list(type = "Gaussian", paramStr = ""),
  var2 = list(type = "Poisson", paramStr = "")
)

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

simVar <- computeSimilarityVar(resLearn)
simClass <- computeSimilarityClass(resLearn)

}
\seealso{
\code{\link{heatmapVar}} \code{\link{heatmapClass}}
}
\author{
Quentin Grimonprez
}
