% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{extractMixtCompObject}
\alias{extractMixtCompObject}
\title{Extract a MixtComp object}
\usage{
extractMixtCompObject(object, K)
}
\arguments{
\item{object}{\link{mixtCompLearn} output}

\item{K}{number of classes of the model to extract}
}
\value{
a \code{MixtComp} object containing the clustering model with K classes
}
\description{
Extract a MixtComp object from a MixtCompLearn object
}
\examples{
# run clustering
resLearn <- mixtCompLearn(data.frame(x = rnorm(500)),
  nClass = 1:3, criterion = "ICL",
  nRun = 1, nCore = 1
)

# extract the model with 2 classes
clustModel <- extractMixtCompObject(resLearn, K = 2)

}
\author{
Quentin Grimonprez
}
