% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Orthogonal_polynomials.R
\name{poly_orth_general}
\alias{poly_orth_general}
\alias{Hermite}
\alias{Legendre}
\alias{ChebyshevT}
\alias{ChebyshevU}
\alias{Jacobi}
\alias{Discrete}
\title{General Orthogonal Polynomials}
\usage{
poly_orth_general(inner_product, degree, norm = FALSE, ...)

Hermite(p, q = p)

Legendre(p, q = p)

ChebyshevT(p, q = p)

ChebyshevU(p, q = p)

Jacobi(p, q = p, alpha = -0.5, beta = alpha)

Discrete(p, q = p, x, w = function(x, ...) 1, ...)
}
\arguments{
\item{inner_product}{An R function of two \code{"polynom"} arguments
with the second polynomial having a default value equal to the
first.  Additional arguments may be specified.  See examples}

\item{degree}{A non-negative integer specifying the maximum degree}

\item{norm}{Logical: should the polynomials be normalized?}

\item{...}{additional arguments passed on to the inner product function}

\item{p, q}{Polynomials}

\item{alpha, beta}{Family parameters for the Jacobi polynomials}

\item{x}{numeric vector defining discrete orthogonal polynomials}

\item{w}{a weight function for discrete orthogonal polynomials}
}
\value{
A \code{"polylist"} object containing the orthogonal set
}
\description{
Generate sets of polynomials orthogonal with respect to a general
inner product.  The inner product is specified by an R function of
(at least) two polynomial arguments.
}
\details{
Discrete orthogonal polynomials, equally or unequally weighted,
are included as special cases.  See the \code{Discrete} inner
product function.

Computations are done using
the recurrence relation with computed coefficients.  If the algebraic
expressions for these recurrence relation coefficients are known
the computation can be made much more efficient.
}
\examples{
(P0 <- poly_orth(0:5, norm = FALSE))
(P1 <- poly_orth_general(Discrete, degree = 5, x = 0:5, norm = FALSE))
sapply(P0-P1, function(x) max(abs(coef(x))))  ## visual check for equality
(P0 <- poly_orth_general(Legendre, 5))
   ### should be same as P0, up to roundoff
(P1 <- poly_orth_general(Jacobi, 5, alpha = 0, beta = 0))
                ### check
sapply(P0-P1, function(x) max(abs(coef(x))))
}
