% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{doAPICall}
\alias{doAPICall}
\title{Perform an API call to the OpenML server.}
\usage{
doAPICall(
  api.call,
  id = NULL,
  url.args = list(),
  post.args = list(),
  file = NULL,
  verbosity = NULL,
  method,
  ...
)
}
\arguments{
\item{api.call}{[\code{character(1)}]\cr
API endpoints listed in \href{https://github.com/openml/OpenML/wiki/API-v1}{APIv1}.}

\item{id}{[\code{integer(1)}]\cr
Optional ID we pass to the API, like runs/list/1.}

\item{url.args}{[\code{list}]\cr
Named list of key-value pairs passed as HTTP GET parameters, e.g.,
key1=value1&key2=value2 to the API call.}

\item{post.args}{[\code{list}]\cr
Optional. A list passed to the \code{body}-arg for \code{\link[httr]{POST}} requests.}

\item{file}{[\code{character(1)}]\cr
Optional filename to write the XML content to.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}

\item{method}{[\code{character(1)}]\cr
HTTP request method. Currently one of GET, POST or DELETE.}

\item{...}{Another possibility to pass key-value pairs for the HTTP request query.
Arguments passed via ... have a higher priority.}
}
\value{
[\code{character(1)}]\cr Unparsed content of the returned XML file.
}
\description{
The function always returns the XML file content provided by the server.
}
\keyword{internal}
