% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertMlrLearnerToOMLFlow.R
\name{convertMlrLearnerToOMLFlow}
\alias{convertMlrLearnerToOMLFlow}
\title{Converts an OMLFlow to an mlr learner.}
\usage{
convertMlrLearnerToOMLFlow(
  lrn,
  name = paste0("mlr.", lrn$id),
  description = NULL,
  ...
)
}
\arguments{
\item{lrn}{[\code{\link[mlr]{Learner}}]\cr
The mlr learner.}

\item{name}{[\code{character(1)}]\cr
The name of the flow object. Default is the learner ID with the prefix
\dQuote{mlr} prepended.}

\item{description}{[\code{character(1)}]\cr
An optional description of the learner.
Default is a short specification of the learner and the associated package.}

\item{...}{[\code{any}]\cr
Further optional parameters that are passed to \code{\link{makeOMLFlow}}.}
}
\value{
[\code{\link{OMLFlow}}].
}
\description{
Creates an \code{\link{OMLFlow}} for an \pkg{mlr} \code{\link[mlr]{Learner}}]
Required if you want to upload an mlr learner to the OpenML server.
}
