% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KDEEM.R
\name{kdeem.h}
\alias{kdeem.h}
\title{Kernel Density-based EM-type algorithm for Semiparametric Mixture Regression
with Unspecified Homogenous Error Distributions}
\usage{
kdeem.h(x, y, C = 2, ini = NULL, maxiter = 200)
}
\arguments{
\item{x}{an n by p data matrix where n is the number of observations and p is the
number of explanatory variables (including the intercept).}

\item{y}{an n-dimensional vector of response variable.}

\item{C}{number of mixture components. Default is 2.}

\item{ini}{initial values for the parameters. Default is NULL, which obtains the initial values
using the \code{\link{kdeem.lse}} function.
If specified, it can be a list with the form of \code{list(beta, prop, tau, pi, h)}, where
\code{beta} is a p by C matrix for regression coefficients of C components,
\code{prop} is an n by C matrix for probabilities of each observation belonging to each component,
calculated based on the initial \code{beta} and \code{h}, \code{tau} is a vector of C precision parameters
(inverse of standard deviation), \code{pi} is a vector of C mixing proportions, and
\code{h} is the bandwidth for kernel estimation.}

\item{maxiter}{maximum number of iterations for the algorithm. Default is 200.}
}
\value{
A list containing the following elements:
\item{posterior}{posterior probabilities of each observation belonging to each component.}
\item{beta}{estimated regression coefficients.}
\item{pi}{estimated mixing proportions.}
\item{h}{bandwidth used for the kernel estimation.}
}
\description{
`kdeem.h' is used for semiparametric mixture regression using a kernel density-based
expectation-maximization (EM)-type algorithm with unspecified
homogeneous error distributions (Hunter and Young, 2012).
}
\details{
'kdeem.h' can be used to estimate parameters in a mixture-of-regressions model
with independent identically distributed errors. The model is defined as follows:
\deqn{f_{Y|\boldsymbol{X}}(y,\boldsymbol{x},\boldsymbol{\theta},g) = \sum_{j=1}^C\pi_jg(y-\boldsymbol{x}^{\top}\boldsymbol{\beta}_j).}
Here, \eqn{\boldsymbol{\theta}=(\pi_1,...,\pi_{C-1},\boldsymbol{\beta}_1^{\top},\cdots,\boldsymbol{\beta}_C^{\top})},
and \eqn{g(\cdot)} represents identical unspecified density functions.
The bandwidth of the kernel density estimation is calculated adaptively using the \code{\link[stats]{bw.SJ}} function from the `stats'
package, which implements the method of Sheather & Jones (1991) for bandwidth selection based on pilot estimation
of derivatives.

For the calculation of \eqn{\beta} in the M-step,
this function employs the universal optimizer \code{\link[ucminf]{ucminf}} from the `ucminf' package.
}
\examples{
# See examples for the `kdeem' function.
}
\references{
Hunter, D. R., & Young, D. S. (2012). Semiparametric mixtures of regressions.
Journal of Nonparametric Statistics, 24(1), 19-38.

Ma, Y., Wang, S., Xu, L., & Yao, W. (2021). Semiparametric mixture regression
with unspecified error distributions. Test, 30, 429-444.
}
\seealso{
\code{\link{kdeem}}, \code{\link{kdeem.lse}}, \code{\link[stats]{bw.SJ}}
for bandwidth calculation, and \code{\link[ucminf]{ucminf}} for beta calculation.
}
