% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Maximin.R
\name{Infer}
\alias{Infer}
\title{Inference method}
\usage{
Infer(
  obj,
  delta = 0,
  gen.size = 500,
  threshold = 0,
  alpha = 0.05,
  alpha.thres = 0.01
)
}
\arguments{
\item{obj}{returned list of Maximin}

\item{delta}{The ridge penalty (Default = 0)}

\item{gen.size}{The generating sample size (Default = 500)}

\item{threshold}{Should generated samples be filtered or not?
if 0, use normal threshold to filter;
if 1, use chi-square threshold to filter;
if 2, do not filter (Default = 0)}

\item{alpha}{confidence value to construct confidence interval (Default = 0.05)}

\item{alpha.thres}{confidence value to select generated samples (Default = 0.01)}
}
\value{
\item{weight}{The weight vector for groups, of length \eqn{L}}
\item{mm.effect}{The aggregated maximin effect (coefficients), of length \eqn{p} or \eqn{p+1}}
\item{mminfer}{The list of length \eqn{n.loading}, each contains the point estimator and confidence interval}
}
\description{
Given the returned list of Maximin, compute the Point estimator and Confidence interval.
}
