% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowRanges.R
\name{rowRanges}
\alias{rowRanges}
\alias{rowRanges,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowRanges,ANY-method}
\alias{colRanges}
\alias{colRanges,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colRanges,ANY-method}
\title{Calculates the minimum and maximum for each row (column) of a matrix-like
object}
\usage{
rowRanges(x, ...)

\S4method{rowRanges}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{rowRanges}{ANY}(x, ...)

colRanges(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{colRanges}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{colRanges}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{...}{Additional arguments passed to specific methods.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
a \code{\link{numeric}} \code{Nx2} (\code{Kx2})
\code{\link{matrix}}, where N (K) is the number of rows (columns) for
which the ranges are calculated.
}
\description{
Calculates the minimum and maximum for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowRanges}} /
\code{matrixStats::\link[matrixStats]{colRanges}}.
}
\note{
Unfortunately for the argument list of the \code{rowRanges()}
generic function we cannot follow the scheme used for the other
row/column matrix summarization generic functions. This is because
we need to be compatible with the historic \code{rowRanges()} getter
for \link[SummarizedExperiment]{RangedSummarizedExperiment} objects.
See \code{?SummarizedExperiment::\link[SummarizedExperiment]{rowRanges}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowRanges(mat)
colRanges(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowRanges}()} and
\code{matrixStats::\link[matrixStats:rowRanges]{colRanges}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For max estimates, see \code{\link{rowMaxs}()}.
\item For min estimates, see \code{\link{rowMins}()}.
\item \code{base::\link{range}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
