% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Peri}
\alias{Peri}
\title{Multivariate Periodogram.}
\usage{
Peri(X)
}
\arguments{
\item{X}{(Txq) data matrix.}
}
\description{
\code{Peri} calculates the periodogram of a multivariate time series.
}
\details{
Returns an array of dimension \code{c(q,q,floor(T/2))}.
}
\examples{
series<-FI.sim(T=1000,q=2,rho=0.7,d=c(0.4,0.4))
peri<-Peri(series)
par(mfrow=c(2,2))
for(i in 1:2){
for(j in 1:2){
plot(Re(peri[i,j,]), type="h")
lines(Im(peri[i,j,]), col=2)
}}
}
