% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_sam_lspace.R
\name{con_sam_lspace}
\alias{con_sam_lspace}
\title{Condition of sample lpoints, as inside/outside of specific L-spaces on the L-moments ratio diagram, using sample.}
\usage{
con_sam_lspace(sample, type = "s", Dist = "BrIII")
}
\arguments{
\item{sample}{for a single site, sample is a vector of observations, e.x. FLOW_AMAX. For multiple sites, sample is a dataframe consisting of multiple columns where each column has the data observed at one site; this dataframe should have column names as station names, e.x. FLOW_AMAX_MULT.}

\item{type}{the type of the sample. It can be "s" for single site, the default, or "m" for multiple sites.}

\item{Dist}{select the distribution to plot its L-space in the background. This can be "BrIII" for Burr Typr-III distribution, "BrXII" for Burr Typr-XII distribution, or "GG" for Generalized Gamma distribution. The default Dist is "BrIII".}
}
\value{
The condition of the L-points in regards to the selected L-space as inside or outside.
}
\description{
Condition of sample lpoints, as inside/outside of specific L-spaces on the L-moments ratio diagram, using sample.
}
\examples{

con_sam_lspace(LMoFit::FLOW_AMAX, type = "s", Dist = "BrIII")
con_sam_lspace(LMoFit::FLOW_AMAX, type = "s", Dist = "BrXII")
con_sam_lspace(LMoFit::FLOW_AMAX, type = "s", Dist = "GG")
con_sam_lspace(LMoFit::FLOW_AMAX_MULT, type = "m", Dist = "BrIII")
con_sam_lspace(LMoFit::FLOW_AMAX_MULT, type = "m", Dist = "BrXII")
con_sam_lspace(LMoFit::FLOW_AMAX_MULT, type = "m", Dist = "GG")

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
