% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMMsolve-class.R
\name{LMMsolveObject}
\alias{LMMsolveObject}
\title{Fitted LMMsolve Object}
\value{
An object of class \code{LMMsolve} contains the following components:
\item{logL}{The restricted log-likelihood at convergence}
\item{sigma2e}{The residual error}
\item{tau2e}{The estimated variance components}
\item{EDdf}{The effective dimensions}
\item{varPar}{The number of variance parameters for each variance component}
\item{VarDf}{The table with variance components}
\item{theta}{The precision parameters}
\item{coefMME}{A vector with all the estimated effects from mixed model equations}
\item{ndxCoefficients}{The indices of the coefficients with the names}
\item{yhat}{The fitted values}
\item{residuals}{The residuals}
\item{nIter}{The number of iterations for the mixed model to converge}
\item{y}{Response variable}
\item{X}{The design matrix for the fixed part of the mixed model}
\item{Z}{The design matrix for the random part of the mixed model}
\item{lGinv}{List with precision matrices for the random terms}
\item{lRinv}{List with precision matrices for the residual}
\item{C}{The mixed model coefficient matrix after last iteration}
\item{cholC}{The cholesky decomposition of coefficient matrix C}
\item{constantREML}{The REML constant}
\item{dim}{The dimensions for each of the fixed and random terms in the
mixed model}
\item{term.labels.f}{The names of the fixed terms in the mixed model}
\item{term.labels.r}{The names of the random terms in the mixed model}
\item{splRes}{An object with definition of spline argument}
\item{family}{An object of class family specifying the distribution and link function}.
}
\description{
An object of class \code{LMMsolve} returned by the LMMsolve function,
representing a fitted linear mixed model. Objects of this class have
methods for the generic functions coef, fitted, residuals, loglik and
deviance.
}
