% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/values.R
\name{values}
\alias{values}
\title{Compute values (price x quantity)}
\usage{
values(
  x,
  pvar,
  qvar,
  pervar,
  prodID,
  sample = "matched",
  matchPeriod = "previous"
)
}
\arguments{
\item{x}{A dataframe containing price, quantity, a time period identifier
and a product identifier. It must have column names.}

\item{pvar}{A character string for the name of the price variable}

\item{qvar}{A character string for the name of the quantity variable}

\item{pervar}{A character string for the name of the time variable. This variable
must contain integers starting at period 1 and increasing in increments of 1 period.
There may be observations on multiple products for each time period.}

\item{prodID}{A character string for the name of the product identifier}

\item{sample}{A character string specifying whether a matched sample
should be used.}

\item{matchPeriod}{A character string specifying which period is used
to determine the set of products used for matching. Options are
"following" or "previous". "following" calculates the expenditures in the current period,
filtering out any products that do not appear in the following period.
"previous" is calculated similarly, using the set of products in the
previous period to filter the current period sample.}
}
\description{
Compute the total value (expenditure), for each time period in
the sample.
}
\examples{
values(CES_sigma_2, pvar = "prices", qvar = "quantities", pervar = "time",
prodID = "prodID", matchPeriod = "previous")

}
