% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{reliability}
\alias{reliability}
\title{Marginal reliability coefficient of IRT}
\usage{
reliability(x)
}
\arguments{
\item{x}{A model fit object from either \code{IRTest_Dich}, \code{IRTest_Poly}, or \code{IRTest_Mix}.}
}
\value{
Estimated marginal reliability coefficient.
}
\description{
Marginal reliability coefficient of IRT
}
\details{
\describe{
\item{Reliability coefficient on summed-score scale}{
In accordance with the concept of \emph{reliability} in classical test theory (CTT),
this function calculates the IRT reliability coefficient.

The basic concept and formula of the reliability coefficient can be expressed as follows (Kim, Feldt, 2010):

An observed score of Item \eqn{i}, \eqn{X_i}, is decomposed as the sum of a true score \eqn{T_i} and an error \eqn{e_i}.
Then, with the assumption of \eqn{\sigma_{T_{i}e_{j}}=\sigma_{e_{i}e_{j}}=0}, the reliability coefficient of a test is defined as;
\deqn{\rho_{TX}=\rho_{XX^{'}}=\frac{\sigma_{T}^{2}}{\sigma_{X}^{2}}=\frac{\sigma_{T}^{2}}{\sigma_{T}^{2}+\sigma_{e}^{2}}=1-\frac{\sigma_{e}^{2}}{\sigma_{X}^{2}}}
}

\item{Reliability coefficient on \eqn{\theta} scale}{
For the coefficient on the \eqn{\theta} scale, this function calculates the parallel-forms reliability (Green et al., 1984; Kim, 2012):
\deqn{
\rho_{\hat{\theta} \hat{\theta}^{'}}
=\frac{\sigma_{E\left(\hat{\theta}\mid \theta \right )}^{2}}{\sigma_{E\left(\hat{\theta}\mid \theta \right )}^{2}+E\left( \sigma_{\hat{\theta}|\theta}^{2} \right)}
=\frac{1}{1+E\left(I\left(\hat{\theta}\right)^{-1}\right)}
}
This assumes that \eqn{\sigma_{E\left(\hat{\theta}\mid \theta \right )}^{2}=\sigma_{\theta}^{2}=1}.
Although the formula is often employed in several IRT studies and applications, the underlying assumption may not be true.
}
}
}
\examples{
\dontrun{
Alldata <- DataGeneration(seed = 1,
                          model_D = rep(1, 10),
                          N=500,
                          nitem_D = 10,
                          latent_dist = "2NM",
                          d = 1.664,
                          sd_ratio = 2,
                          prob = 0.3)

data <- Alldata$data_D

# Analysis

M1 <- IRTest_Dich(data)


# Reliability coefficients
rel <- reliability(M1)

## On the summed-score scale
rel$summed.score.scale$test
rel$summed.score.scale$item

## On the summed-score scale
rel$theta.scale

}
}
\references{
Green, B.F., Bock, R.D., Humphreys, L.G., Linn, R.L., & Reckase, M.D. (1984). Technical guidelines for assessing computerized adaptive tests. \emph{Journal of Educational Measurement, 21}(4), 347–360.
Kim, S. (2012). A note on the reliability coefficients for item response model-based ability estimates. \emph{Psychometrika, 77}(1), 153-162.
Kim, S., Feldt, L.S. (2010). The estimation of the IRT reliability coefficient and its lower and upper bounds, with comparisons to CTT reliability statistics. \emph{Asia Pacific Education Review, 11}, 179–188.
}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
