% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ics.outlier.R
\name{plot.ICS_Out}
\alias{plot.ICS_Out}
\title{Distances Plot for an 'ICS_Out' Object}
\usage{
\method{plot}{ICS_Out}(
  x,
  pch.out = 16,
  pch.good = 4,
  col.out = 1,
  col.good = grey(0.5),
  col.cut = 1,
  lwd.cut = 1,
  lty.cut = 1,
  xlab = "Observation Number",
  ylab = "ICS distances",
  ...
)
}
\arguments{
\item{x}{object of class \code{"ICS_Out"}.}

\item{pch.out}{plotting symbol for the outliers.}

\item{pch.good}{plotting symbol for the 'good' data points.}

\item{col.out}{color for the outliers.}

\item{col.good}{color for the 'good' data points.}

\item{col.cut}{color for cut-off line.}

\item{lwd.cut}{lwd value for cut-off line.}

\item{lty.cut}{lty value for cut-off line.}

\item{xlab}{default x-axis label.}

\item{ylab}{default y-axis label.}

\item{...}{other arguments for \code{plot}}
}
\value{
A plot is displayed.
}
\description{
Distances plot for an 'ICS_Out' object visualizing the separation of the outliers from the good data points.
}
\details{
For the figure the IC distances are plotted versus their index. The cut-off value for distances is given as a horizontal line and all observations above the line are considered as outliers.
}
\author{
Aurore Archimbaud and Klaus Nordhausen
}
