% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{tkmeans_clust}
\alias{tkmeans_clust}
\title{Trimmed k-means clustering}
\usage{
tkmeans_clust(X, k, clusters_only = FALSE, alpha = 0.05, ...)
}
\arguments{
\item{X}{a numeric matrix or data frame of the data. It corresponds to the
argument \code{x}.}

\item{k}{the number of clusters searched for. It corresponds to the argument
\code{k}.}

\item{clusters_only}{boolean. If \code{TRUE} only the partition of the data
is returned as a vector. If \code{FALSE} the usual output of the
\link[tclust]{tkmeans} function is returned.}

\item{alpha}{the proportion of observations to be trimmed.}

\item{...}{other arguments to pass to the \code{\link[tclust:tkmeans]{tclust::tkmeans()}}}
}
\value{
If \code{clusters_only} is \code{TRUE} a vector of the new partition
of the data is returned, i.e a vector of integers (from \code{1:k})
indicating the cluster to which each observation is allocated.
0 indicates trimmed observations.

Otherwise a list is returned with the following components:
\item{clust_method}{the name of the clustering method, i.e. "tkmeans".}
\item{clusters}{the vector of the new partition of the data, i.e. a vector of
integers (from \code{1:k}) indicating the cluster to which each observation
is allocated. 0 indicates trimmed observations.}
\item{...}{an object of class \code{"tkmeans"}}.
}
\description{
Wrapper for performing trimmed k-means clustering from
\code{\link[tclust:tkmeans]{tclust::tkmeans()}}.
}
\examples{
tkmeans_clust(iris[,1:4], k = 3, alpha = 0.1, clusters_only = TRUE)
}
\seealso{
\code{\link[tclust:tkmeans]{tclust::tkmeans()}}
}
\author{
Aurore Archimbaud
}
