% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatters.R
\name{ICS_mcd}
\alias{ICS_mcd}
\alias{ICS_mcd_raw}
\alias{ICS_mcd_rwt}
\title{MCD location and Scatter Estimates for ICS}
\usage{
ICS_mcd_raw(x, location = FALSE, nsamp = "deterministic", alpha = 0.5, ...)

ICS_mcd_rwt(x, location = FALSE, nsamp = "deterministic", alpha = 0.5, ...)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{location}{a logical indicating whether to include the MCD-estimate of
location (defaults to \code{FALSE}).}

\item{nsamp}{number of subsets used for initial estimates or \code{"best"},
\code{"exact"} or \code{"deterministic"} (default).}

\item{alpha}{numeric parameter controlling the size of the subsets over
which the determinant is minimized as in \code{\link[rrcov:CovMcd]{rrcov::CovMcd()}}.}

\item{...}{potential further arguments passed to \code{\link[rrcov:CovMcd]{rrcov::CovMcd()}}.}
}
\value{
An object of class \code{"ICS_scatter"} with the following
components:
\item{location}{if requested, a numeric vector giving the location
estimate.}
\item{scatter}{a numeric matrix giving the estimate of the scatter matrix.}
\item{label}{a character string providing a label for the scatter matrix.}
}
\description{
It is a wrapper for the (reweighted) MCD estimators of location and scatter
as computed by \code{\link[rrcov:CovMcd]{rrcov::CovMcd()}}.
}
\details{
\itemize{
\item \code{\link[=ICS_mcd_raw]{ICS_mcd_raw()}}: computes the raw MCD estimates.
\item \code{\link[=ICS_mcd_rwt]{ICS_mcd_rwt()}}: computes the reweighted MCD estimates.
}
}
\seealso{
\code{\link[rrcov:CovMcd]{rrcov::CovMcd()}}
}
\author{
Andreas Alfons and Aurore Archimbaud
}
