

test_that("ase works", {
  set.seed(3344)
  g <- sample_gnp(100,0.1)
  set.seed(3744)
  z1 <- ase(g)
  expect_equal(dim(z1), c(gorder(g),2))
  expect_equal(sum(z1[,1]^2), 1)
  expect_equal(sum(z1[,2]^2), 1)
  set.seed(3744)
  z2 <- ase(g,adjust.diag=TRUE)
  expect_equal(dim(z2), c(gorder(g),2))
  expect_equal(sum(z2[,1]^2), 1)
  expect_equal(sum(z2[,2]^2), 1)
  set.seed(3744)
  z3 <- ase(g,adjust.diag=TRUE,scale.by.value=TRUE,d=3)
  A <- as_adjacency_matrix(g)
  degs <- degree(g)
  A <- A+Matrix::Diagonal(x=degs/(gorder(g)-1))
  a <- RSpectra::eigs(A,k=3)$values
  expect_equal(dim(z3), c(gorder(g),3))
  expect_equal(sum(z3[,1]^2), a[1])
  expect_equal(sum(z3[,2]^2), a[2])
  expect_equal(sum(z3[,3]^2), a[3])
  set.seed(632)
  g <- sample_sbm(200,rbind(c(.1,.025),c(.025,.2)),c(100,100))
  set.seed(362)
  z4 <- ase(g)
  m <- Mclust(z4,verbose=FALSE)
  expect_equal(m$G, 2)
  expect_equal(sum(m$classification==rep(1:2,each=100)), 200)
  set.seed(362)
  z5 <- ase(g,laplacian=TRUE)
  expect_equal(sum(z5[,1]^2), 1)
  expect_equal(sum(z5[,2]^2), 1)
  set.seed(62)
  z6 <- ase(g,laplacian=TRUE,normalize=TRUE)
  expect_equal(sum(z6[,1]^2), 1)
  expect_equal(sum(z6[,2]^2), 1)
  set.seed(62)
  z7 <- lse(g,normalize=TRUE)
  expect_equal(z6, z7)
})

