% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completer.r
\name{completer}
\alias{completer}
\title{completer}
\usage{
completer(a, nimpute, oneimpute = FALSE, mydata)
}
\arguments{
\item{a}{An object of class \code{transcan} or \code{aregImpute}}

\item{nimpute}{A numeric vector between 1 and \code{a$n.impute}. For \code{transcan} object, this is set to 1. For \code{aregImpute} object, returns a list of \code{nimpute} datasets when \code{oneimpute} is set to \code{FALSE} (default).}

\item{oneimpute}{A logical vector. When set to \code{TRUE}, returns a single completed dataset for the imputation number specified by \code{nimpute}}

\item{mydata}{A data frame in which its missing values will be imputed.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{      A single or a list of completed dataset(s).
}\if{html}{\out{</div>}}
}
\description{
Create imputed dataset(s) using \code{transcan} and \code{aregImpute} objects
}
\details{
Similar in function to \code{mice::complete}, this function uses \code{transcan} and \code{aregImpute} objects to impute missing data
and returns the completed dataset(s) as a dataframe or a list.
It assumes that \code{transcan} is used for single regression imputation.
}
\examples{
\dontrun{
mtcars$hp[1:5]    <- NA
mtcars$wt[1:10]   <- NA
myrform <- ~ wt + hp + I(carb)
mytranscan  <- transcan( myrform,  data = mtcars, imputed = TRUE,
  pl = FALSE, pr = FALSE, trantab = TRUE, long = TRUE)
myareg      <- aregImpute(myrform, data = mtcars, x=TRUE, n.impute = 5)
completer(mytranscan)                    # single completed dataset
completer(myareg, 3, oneimpute = TRUE)
# single completed dataset based on the `n.impute`th set of multiple imputation
completer(myareg, 3)
# list of completed datasets based on first `nimpute` sets of multiple imputation
completer(myareg)
# list of completed datasets based on all available sets of multiple imputation
}
}
\author{
\if{html}{\out{<div class="sourceCode">}}\preformatted{      Yong-Hao Pua, Singapore General Hospital
}\if{html}{\out{</div>}}
}
