% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descGetMissing.R
\name{descGetMissing}
\alias{descGetMissing}
\title{Get statistics for missing data}
\usage{
descGetMissing(
  x,
  html = TRUE,
  number_first = TRUE,
  percentage_sign = TRUE,
  language = "en",
  useNA.digits = 1,
  ...
)
}
\arguments{
\item{x}{The variable that you want the statistics for}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}

\item{number_first}{If the number should be given or if the percentage
should be presented first. The second is encapsulated in parentheses ().
This is only used together with the useNA variable.}

\item{percentage_sign}{If you want to suppress the percentage sign you
can set this variable to FALSE. You can also choose something else that
the default \% if you so wish by setting this variable. Note, this is
only used when combined with the missing information.}

\item{language}{The ISO-639-1 two-letter code for the language of
interest. Currently only english is distinguished from the ISO
format using a ',' as the separator in the \code{\link{txtInt}}
function.}

\item{useNA.digits}{The number of digits to use for the
missing percentage, defaults to the overall \code{digits}.}

\item{...}{Passed on to \code{\link{describeFactors}}}
}
\value{
\code{vector} A vector with the missing estimate
}
\description{
This function calculates the amount of missing per row for \code{\link{describeMean}},
\code{\link{describeMedian}} and custom description functions.
It will return invisibly when no missing values are present.
}
