% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colProds.R, R/rowProds.R
\name{colProds,DelayedMatrix-method}
\alias{colProds,DelayedMatrix-method}
\alias{colProds,SolidRleArraySeed-method}
\alias{rowProds,DelayedMatrix-method}
\title{Calculates the product for each row (column) of a matrix-like object}
\usage{
\S4method{colProds}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  method = c("direct", "expSumLog"),
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colProds}{SolidRleArraySeed}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  method = c("direct", "expSumLog"),
  ...,
  useNames = TRUE
)

\S4method{rowProds}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  method = c("direct", "expSumLog"),
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{method}{A character vector of length one that specifies the
how the product is calculated. Note, that this is not a generic
argument and not all implementation have to provide it.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the product for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowProds}} /
\code{matrixStats::\link[matrixStats]{colProds}}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'HDF5ArraySeed' seed
# NOTE: Requires that the HDF5Array package is installed
library(HDF5Array)
dm_HDF5 <- writeHDF5Array(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))

colProds(dm_matrix)

rowProds(dm_matrix)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowProds}()} and
\code{matrixStats::\link[matrixStats:rowProds]{colProds}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For sums across rows (columns), see
\code{\link[MatrixGenerics]{rowSums2}()} (\code{\link[MatrixGenerics:colSums2]{colSums2()}})
\item \code{base::\link{prod}()}.
}
}
\author{
Peter Hickey
}
