% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colMads.R, R/colSds.R, R/rowMads.R, R/rowSds.R
\name{colMads,DelayedMatrix-method}
\alias{colMads,DelayedMatrix-method}
\alias{colSds,DelayedMatrix-method}
\alias{rowMads,DelayedMatrix-method}
\alias{rowSds,DelayedMatrix-method}
\title{Calculates the median absolute deviation for each row (column) of a
matrix-like object}
\usage{
\S4method{colMads}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  center = NULL,
  constant = 1.4826,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{colSds}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  center = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowMads}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  center = NULL,
  constant = 1.4826,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowSds}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  center = NULL,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{center}{(optional) the center, defaults to the row means}

\item{constant}{A scale factor. See \code{stats::\link[stats]{mad}()} for
details.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set. \strong{Only \code{useNames = NA} is currently supported, other values are silently ignored.}}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the median absolute deviation for each row (column) of a
matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowMads}} /
\code{matrixStats::\link[matrixStats]{colMads}}.
}
\examples{
# A DelayedMatrix with a 'data.frame' seed
dm_df <- DelayedArray(data.frame(C1 = rep(1L, 5),
                                 C2 = as.integer((0:4) ^ 2),
                                 C3 = seq(-5L, -1L, 1L)))
# A DelayedMatrix with a 'DataFrame' seed
dm_DF <- DelayedArray(S4Vectors::DataFrame(C1 = rep(1L, 5),
                                           C2 = as.integer((0:4) ^ 2),
                                           C3 = seq(-5L, -1L, 1L)))

colMads(dm_df)

colSds(dm_df)

rowMads(dm_DF)

rowSds(dm_DF)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowSds]{rowMads}()} and
\code{matrixStats::\link[matrixStats:rowSds]{colMads}()} which are used
when  the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link[MatrixGenerics]{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item For non-robust standard deviation estimates, see
\code{\link[MatrixGenerics]{rowSds}()}.
}
}
\author{
Peter Hickey
}
